/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.operand.registry;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.jql.operand.FunctionOperandHandler;
import com.atlassian.jira.jql.operand.registry.JqlFunctionHandlerRegistry;
import com.atlassian.jira.jql.operand.registry.LazyResettableJqlFunctionHandlerRegistry;
import com.atlassian.jira.plugin.jql.function.JqlFunctionModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptors;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.query.operand.FunctionOperand;
import java.util.List;

public class PluginsAwareJqlFunctionHandlerRegistry
implements JqlFunctionHandlerRegistry,
Startable {
    private final LazyResettableJqlFunctionHandlerRegistry delegateRegistry;
    private final EventPublisher eventPublisher;

    public PluginsAwareJqlFunctionHandlerRegistry(PluginAccessor pluginAccessor, EventPublisher eventPublisher, ModuleDescriptors.Orderings moduleDescriptorOrderings, I18nHelper i18nHelper) {
        this.delegateRegistry = new LazyResettableJqlFunctionHandlerRegistry(pluginAccessor, moduleDescriptorOrderings, i18nHelper);
        this.eventPublisher = eventPublisher;
    }

    @PluginEventListener
    public void onPluginModuleEnabled(PluginModuleEnabledEvent event) {
        if (event.getModule() instanceof JqlFunctionModuleDescriptor) {
            this.delegateRegistry.reset();
        }
    }

    @PluginEventListener
    public void onPluginModuleDisabled(PluginModuleDisabledEvent event) {
        if (event.getModule() instanceof JqlFunctionModuleDescriptor) {
            this.delegateRegistry.reset();
        }
    }

    @Override
    public FunctionOperandHandler getOperandHandler(FunctionOperand operand) {
        return this.delegateRegistry.getOperandHandler(operand);
    }

    @Override
    public List<String> getAllFunctionNames() {
        return this.delegateRegistry.getAllFunctionNames();
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
        this.delegateRegistry.reset();
    }
}

