/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.permission;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.permission.LiteralSanitiser;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.jql.resolver.ProjectIndexInfoResolver;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

@NonInjectableComponent
public class ProjectLiteralSanitiser
implements LiteralSanitiser {
    private final NameResolver<Project> projectResolver;
    private final PermissionManager permissionManager;
    private final IndexInfoResolver<Project> projectIndexInfoResolver;
    private final ApplicationUser user;

    public ProjectLiteralSanitiser(NameResolver<Project> projectResolver, PermissionManager permissionManager, ApplicationUser user) {
        this(projectResolver, permissionManager, new ProjectIndexInfoResolver(projectResolver), user);
    }

    ProjectLiteralSanitiser(NameResolver<Project> projectResolver, PermissionManager permissionManager, IndexInfoResolver<Project> indexInfoResolver, ApplicationUser user) {
        this.projectResolver = (NameResolver)Assertions.notNull((String)"projectResolver", projectResolver);
        this.permissionManager = (PermissionManager)Assertions.notNull((String)"permissionManager", (Object)permissionManager);
        this.projectIndexInfoResolver = (IndexInfoResolver)Assertions.notNull((String)"indexInfoResolver", indexInfoResolver);
        this.user = user;
    }

    @Override
    public LiteralSanitiser.Result sanitiseLiterals(List<QueryLiteral> literals) {
        Assertions.notNull((String)"literals", literals);
        boolean isModified = false;
        LinkedHashSet<QueryLiteral> resultantLiterals = new LinkedHashSet<QueryLiteral>();
        for (QueryLiteral literal : literals) {
            List<String> stringIds = this.getIndexValues(literal);
            for (String stringId : stringIds) {
                Long projectId = new Long(stringId);
                Project project = (Project)this.projectResolver.get(projectId);
                if (project != null && !this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, this.user)) {
                    resultantLiterals.add(new QueryLiteral(literal.getSourceOperand(), projectId));
                    isModified = true;
                    continue;
                }
                resultantLiterals.add(literal);
            }
        }
        return new LiteralSanitiser.Result(isModified, new ArrayList<QueryLiteral>(resultantLiterals));
    }

    List<String> getIndexValues(QueryLiteral literal) {
        if (literal.getStringValue() != null) {
            return this.projectIndexInfoResolver.getIndexedValues(literal.getStringValue());
        }
        if (literal.getLongValue() != null) {
            return this.projectIndexInfoResolver.getIndexedValues(literal.getLongValue());
        }
        return Collections.emptyList();
    }
}

