/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.parameters.lucene.PermissionQueryFactory;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.PermissionClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.resolver.UserResolver;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.query.clause.TerminalClause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InjectableComponent
public class WatcherClauseQueryFactory
implements ClauseQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(WatcherClauseQueryFactory.class);
    private final ClauseQueryFactory delegateClauseQueryFactory;
    private final WatcherManager watcherManager;

    public WatcherClauseQueryFactory(JqlOperandResolver operandResolver, UserResolver userResolver, WatcherManager watcherManager, PermissionQueryFactory permissionQueryFactory) {
        this.watcherManager = watcherManager;
        this.delegateClauseQueryFactory = PermissionClauseQueryFactory.create(operandResolver, userResolver, permissionQueryFactory, SystemSearchConstants.forWatchers().getIndexField());
    }

    public QueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        if (this.watcherManager.isWatchingEnabled()) {
            return this.delegateClauseQueryFactory.getQuery(queryCreationContext, terminalClause);
        }
        log.debug("Attempt to search watches field when watching is disabled.");
        return QueryFactoryResult.createFalseResult();
    }
}

