/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.cache.Supplier;
import com.atlassian.extras.api.LicenseException;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.license.Jira6xServiceDeskPluginEncodedLicenseSupplier;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicenseDetailsFactory;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jira6xServiceDeskPluginLicenseSupplier
implements Supplier<Option<LicenseDetails>> {
    private static final Logger LOG = LoggerFactory.getLogger(Jira6xServiceDeskPluginLicenseSupplier.class);
    private final Jira6xServiceDeskPluginEncodedLicenseSupplier encodedLicenseSupplier;
    private final LicenseDetailsFactory licenseDetailsFactory;

    @Inject
    public Jira6xServiceDeskPluginLicenseSupplier(@Nonnull ApplicationProperties applicationProperties, @Nonnull LicenseDetailsFactory licenseDetailsFactory) {
        this(new Jira6xServiceDeskPluginEncodedLicenseSupplier((ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties)), licenseDetailsFactory);
    }

    @VisibleForTesting
    Jira6xServiceDeskPluginLicenseSupplier(@Nonnull Jira6xServiceDeskPluginEncodedLicenseSupplier raw, @Nonnull LicenseDetailsFactory licenseDetailsFactory) {
        this.encodedLicenseSupplier = (Jira6xServiceDeskPluginEncodedLicenseSupplier)Assertions.notNull((String)"raw", (Object)raw);
        this.licenseDetailsFactory = (LicenseDetailsFactory)Assertions.notNull((String)"licenseDetailsFactory", (Object)licenseDetailsFactory);
    }

    public Option<LicenseDetails> get() {
        try {
            return this.encodedLicenseSupplier.get().map(this.licenseDetailsFactory::getLicense).filter(Jira6xServiceDeskPluginLicenseSupplier::isServiceDeskLicense);
        }
        catch (LicenseException invalidLicense) {
            LOG.debug("Invalid Service Desk plugin license", (Throwable)invalidLicense);
            return Option.none();
        }
    }

    public void moveToUpgradeStore() {
        this.encodedLicenseSupplier.moveToUpgradeStore();
    }

    private static boolean isServiceDeskLicense(LicenseDetails licenseDetails) {
        if (!licenseDetails.hasApplication(ApplicationKeys.SERVICE_DESK)) {
            LOG.debug("Invalid Service Desk plugin license");
            return false;
        }
        return true;
    }
}

