/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.license.MultiLicenseStore;
import com.atlassian.jira.license.ProductLicense;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class MultiLicenseStoreImpl
implements MultiLicenseStore {
    private static final String ID_COLUMN = "id";
    private final EntityEngine entityEngine;
    private final ApplicationProperties applicationProperties;

    public MultiLicenseStoreImpl(EntityEngine entityEngine, ApplicationProperties applicationProperties) {
        this.entityEngine = (EntityEngine)Assertions.notNull((String)"entityEngine", (Object)entityEngine);
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
    }

    @Nonnull
    public List<String> retrieve() {
        return (List)this.entityEngine.selectFrom(Entity.PRODUCT_LICENSE).findAll().orderBy(ID_COLUMN).stream().filter(Objects::nonNull).map(ProductLicense::getLicenseKey).collect(CollectorsUtil.toImmutableList());
    }

    @Override
    public void store(@Nonnull Iterable<String> licenses) {
        Preconditions.checkNotNull(licenses, (Object)"newLicenseKeys");
        if (Iterables.isEmpty(licenses)) {
            throw new IllegalArgumentException("You must store at least one license.");
        }
        if (Iterables.any(licenses, (Predicate)Predicates.isNull())) {
            throw new IllegalArgumentException("You cannot store null licenses - no changes have been made to licenses.");
        }
        this.clear();
        for (String licenseKey : licenses) {
            this.entityEngine.createValue(Entity.PRODUCT_LICENSE, new ProductLicense(licenseKey));
        }
    }

    @Override
    public void resetOldBuildConfirmation() {
        this.applicationProperties.setOption("jira.install.oldlicense.confirmed", false);
        this.applicationProperties.setString("jira.install.oldlicense.confirmed.timestamp", "");
        this.applicationProperties.setString("jira.install.oldlicense.confirmed.user", "");
    }

    @Override
    public void confirmProceedUnderEvaluationTerms(String userName) {
        this.applicationProperties.setOption("jira.install.oldlicense.confirmed", true);
        this.applicationProperties.setString("jira.install.oldlicense.confirmed.user", userName);
        this.applicationProperties.setString("jira.install.oldlicense.confirmed.timestamp", String.valueOf(System.currentTimeMillis()));
    }

    @Override
    public void clear() {
        this.entityEngine.delete(Delete.from(Entity.PRODUCT_LICENSE).all());
    }

    @Override
    public String retrieveServerId() {
        return this.applicationProperties.getString("jira.sid.key");
    }

    @Override
    public void storeServerId(String serverId) {
        this.applicationProperties.setString("jira.sid.key", serverId);
    }
}

