/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.botocss.Botocss;
import com.atlassian.botocss.BotocssStyles;
import com.atlassian.jira.mail.CssInliner;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BotoCssInliner
implements CssInliner {
    private static final Logger logger = LoggerFactory.getLogger(BotoCssInliner.class);
    static final int EXPIRE_SECS = 30;
    private final LoadingCache<Object, BotocssStyles> botocssStyles;
    private final ImmutableList<String> cssFilenames = ImmutableList.builder().add((Object)"templates/email/css/aui-styles.css").add((Object)"templates/email/css/all-clients.css").add((Object)"templates/email/css/wiki-renderer.css").add((Object)"templates/email/css/jira-styles.css").add((Object)"templates/email/css/jira-status-lozenges.css").build();

    public BotoCssInliner() {
        this.botocssStyles = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).removalListener((RemovalListener)new BotocssRemovalListener()).build((CacheLoader)new BotocssCreator());
    }

    @Override
    public String applyStyles(String html) {
        if (html == null) {
            return null;
        }
        return Botocss.inject((String)html, (BotocssStyles)((BotocssStyles)this.botocssStyles.getUnchecked((Object)this)));
    }

    void performCacheMaintenance() {
        this.botocssStyles.cleanUp();
    }

    private BotocssStyles createStyles() {
        StringBuilder stringBuilder = new StringBuilder();
        InputStream stream = null;
        for (String filename : this.cssFilenames) {
            try {
                stream = (InputStream)Preconditions.checkNotNull((Object)this.getClass().getClassLoader().getResourceAsStream(filename));
                stringBuilder.append(IOUtils.toString((InputStream)stream, (String)"UTF-8"));
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)stream);
        }
        return BotocssStyles.parse((String[])new String[]{stringBuilder.toString()});
    }

    private static class BotocssRemovalListener
    implements RemovalListener<Object, BotocssStyles> {
        private BotocssRemovalListener() {
        }

        public void onRemoval(RemovalNotification<Object, BotocssStyles> notification) {
            logger.trace("Removed styles: {}", notification.getValue());
        }
    }

    private class BotocssCreator
    extends CacheLoader<Object, BotocssStyles> {
        private BotocssCreator() {
        }

        public BotocssStyles load(Object key) throws Exception {
            BotocssStyles styles = BotoCssInliner.this.createStyles();
            logger.trace("Creating new styles: {}", (Object)styles);
            return styles;
        }
    }
}

