/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding;

import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.onboarding.FirstUseFlow;
import com.atlassian.jira.onboarding.FirstUseFlowModuleDescriptor;
import com.atlassian.jira.onboarding.OnboardingService;
import com.atlassian.jira.onboarding.OnboardingStore;
import com.atlassian.jira.onboarding.UserChecker;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.landingpage.LandingPageRedirectManager;
import com.atlassian.jira.web.landingpage.PageRedirect;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnboardingServiceImpl
implements OnboardingService,
Startable {
    private static final int ONBOARDING_PRIORITY = 10;
    private static final Logger log = LoggerFactory.getLogger(OnboardingServiceImpl.class);
    private final PluginAccessor pluginAccessor;
    private final OnboardingStore store;
    private final UserChecker userChecker;
    private final LandingPageRedirectManager landingPageRedirectManager;

    public OnboardingServiceImpl(PluginAccessor pluginAccessor, OnboardingStore store, UserChecker userChecker, LandingPageRedirectManager landingPageRedirectManager) {
        this.pluginAccessor = pluginAccessor;
        this.store = store;
        this.userChecker = userChecker;
        this.landingPageRedirectManager = landingPageRedirectManager;
    }

    @Override
    public boolean hasCompletedFirstUseFlow(@Nonnull ApplicationUser user) {
        return this.store.getBoolean(user, "jira.onboarding.first.use.flow.completed");
    }

    @Override
    public void completeFirstUseFlow(@Nonnull ApplicationUser user) {
        this.store.setBoolean(user, "jira.onboarding.first.use.flow.completed", true);
    }

    @Override
    public void setCurrentFirstUseFlowSequence(@Nonnull ApplicationUser user, @Nonnull String sequenceKey) {
        this.store.setString(user, "jira.onboarding.first.use.flow.current.sequence", sequenceKey);
    }

    @Override
    @Nullable
    public String getCurrentFirstUseFlowSequence(@Nonnull ApplicationUser user) {
        return this.store.getString(user, "jira.onboarding.first.use.flow.current.sequence");
    }

    @Override
    @Nullable
    public FirstUseFlow getFirstUseFlow(@Nullable ApplicationUser user) {
        if (user == null || this.hasResolvedFirstUseFlow(user)) {
            return null;
        }
        FirstUseFlow firstUseFlow = this.evaluateFirstUseFlowChoice(user);
        if (firstUseFlow == null) {
            this.resolveFirstUseFlow(user);
        } else if (this.userChecker.isImpersonationActive(user)) {
            log.info("User Impersonation is active: onboarding will not be displayed for the current user ({})", (Object)user.getUsername());
            return null;
        }
        return firstUseFlow;
    }

    @Nullable
    private FirstUseFlow evaluateFirstUseFlowChoice(@Nonnull ApplicationUser user) {
        if (this.userChecker.isOnDemandSysAdmin(user) || this.hasCompletedFirstUseFlow(user)) {
            return null;
        }
        if (this.hasStartedFirstUseFlow(user)) {
            String startedFlowKey = this.getStartedFirstUseFlowKey(user);
            if (startedFlowKey == null) {
                return null;
            }
            FirstUseFlowModuleDescriptor chosenFlowDescriptor = this.getFirstUseFlowModuleDescriptorByKey(startedFlowKey);
            if (chosenFlowDescriptor == null) {
                return null;
            }
            return (FirstUseFlow)chosenFlowDescriptor.getModule();
        }
        if (this.userChecker.firstTimeLoggingIn(user)) {
            return this.startHighestWeightFlow(user);
        }
        return null;
    }

    @Nullable
    private FirstUseFlow startHighestWeightFlow(@Nonnull ApplicationUser user) {
        List<FirstUseFlowModuleDescriptor> flows = this.getOrderedFirstUseFlowDescriptors();
        for (FirstUseFlowModuleDescriptor flow : flows) {
            if (!((FirstUseFlow)flow.getModule()).isApplicable(user)) continue;
            this.markFirstUseFlowStarted(user, flow);
            return (FirstUseFlow)flow.getModule();
        }
        return null;
    }

    private void markFirstUseFlowStarted(@Nonnull ApplicationUser user, @Nonnull FirstUseFlowModuleDescriptor firstUseFlowModuleDescriptor) {
        this.store.setString(user, "jira.onboarding.first.use.flow.started", firstUseFlowModuleDescriptor.getKey());
    }

    private boolean hasStartedFirstUseFlow(@Nonnull ApplicationUser user) {
        return this.store.isSet(user, "jira.onboarding.first.use.flow.started");
    }

    private boolean hasResolvedFirstUseFlow(@Nonnull ApplicationUser user) {
        return this.store.getBoolean(user, "jira.onboarding.first.use.flow.resolved");
    }

    @Override
    @Nullable
    public String getStartedFirstUseFlowKey(@Nonnull ApplicationUser user) {
        return this.store.getString(user, "jira.onboarding.first.use.flow.started");
    }

    private void resolveFirstUseFlow(@Nonnull ApplicationUser user) {
        this.store.setBoolean(user, "jira.onboarding.first.use.flow.resolved", true);
    }

    @Nullable
    private FirstUseFlowModuleDescriptor getFirstUseFlowModuleDescriptorByKey(@Nonnull String key) {
        List unfilteredDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(FirstUseFlowModuleDescriptor.class);
        FirstUseFlowModuleDescriptor matchingDescriptor = null;
        Iterable filteredDescriptors = Iterables.filter((Iterable)unfilteredDescriptors, input -> null != input && key.equals(input.getKey()));
        Iterator iterator = filteredDescriptors.iterator();
        if (iterator.hasNext()) {
            matchingDescriptor = (FirstUseFlowModuleDescriptor)iterator.next();
        }
        return matchingDescriptor;
    }

    @Nonnull
    private List<FirstUseFlowModuleDescriptor> getOrderedFirstUseFlowDescriptors() {
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(FirstUseFlowModuleDescriptor.class);
        ArrayList x = Lists.newArrayList((Iterable)descriptors);
        Collections.sort(x);
        return x;
    }

    public void start() {
        this.landingPageRedirectManager.registerRedirect(new OnboardingLandingPageRedirect(), 10);
    }

    private class OnboardingLandingPageRedirect
    implements PageRedirect {
        private OnboardingLandingPageRedirect() {
        }

        @Override
        public Optional<String> url(ApplicationUser user) {
            return Optional.ofNullable(user).map(OnboardingServiceImpl.this::getFirstUseFlow).map(FirstUseFlow::getUrl);
        }
    }
}

