/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webresource;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceUrlProviderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraWebResourceUrlProvider
extends WebResourceUrlProviderImpl {
    private static final Logger log = LoggerFactory.getLogger(JiraWebResourceUrlProvider.class);
    private String staticBaseUrl;

    public JiraWebResourceUrlProvider(ApplicationProperties appProps, WebResourceIntegration webResourceIntegration) {
        super(webResourceIntegration);
        String cdn = appProps.getDefaultBackedString("jira.cdn.static.prefix");
        if (cdn != null) {
            if (cdn.endsWith("/")) {
                cdn = cdn.substring(0, cdn.length() - 1);
            }
            log.info("CDN static prefix in use, prefix=" + cdn);
        }
        this.staticBaseUrl = cdn;
    }

    public String getStaticResourcePrefix(String resourceCounter, UrlMode urlMode) {
        if (this.staticBaseUrl != null) {
            return this.staticBaseUrl + super.getStaticResourcePrefix(resourceCounter, UrlMode.RELATIVE);
        }
        return super.getStaticResourcePrefix(resourceCounter, urlMode);
    }

    public String getStaticResourcePrefix(UrlMode urlMode) {
        if (this.staticBaseUrl != null) {
            return this.staticBaseUrl + super.getStaticResourcePrefix(UrlMode.RELATIVE);
        }
        return super.getStaticResourcePrefix(urlMode);
    }
}

