/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.portal;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortalPageStore;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.CacheObject;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

@EventComponent
public class CachingPortalPageStore
implements PortalPageStore {
    private final PortalPageStore delegateStore;
    private final Cache<String, List<Long>> cacheByUser;
    private final Cache<Long, CacheObject<PortalPage>> cacheById;
    private volatile Long systemDefaultPortalPageId = null;

    public CachingPortalPageStore(PortalPageStore delegateStore, CacheManager cacheManager) {
        Assertions.notNull((String)"delegateStore", (Object)delegateStore);
        this.delegateStore = delegateStore;
        this.cacheByUser = cacheManager.getCache(CachingPortalPageStore.class.getName() + ".cacheByUser", (CacheLoader)new ByUserCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.cacheById = cacheManager.getCache(CachingPortalPageStore.class.getName() + ".cacheById", (CacheLoader)new ByIdCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.flush();
    }

    @Override
    public EnclosedIterable<PortalPage> get(SharedEntityAccessor.RetrievalDescriptor ids) {
        return this.delegateStore.get(ids);
    }

    @Override
    public EnclosedIterable<PortalPage> getAll() {
        return this.delegateStore.getAll();
    }

    @Override
    public PortalPage getSystemDefaultPortalPage() {
        PortalPage page;
        if (this.systemDefaultPortalPageId == null && (page = this.delegateStore.getSystemDefaultPortalPage()) != null) {
            this.systemDefaultPortalPageId = page.getId();
        }
        if (this.systemDefaultPortalPageId != null) {
            return this.getPortalPage(this.systemDefaultPortalPageId);
        }
        return null;
    }

    @Override
    public Collection<PortalPage> getAllOwnedPortalPages(ApplicationUser owner) {
        Assertions.notNull((String)"owner", (Object)owner);
        return this.getAllOwnedPortalPages(owner.getKey());
    }

    @Override
    public Collection<PortalPage> getAllOwnedPortalPages(String userKey) {
        Assertions.notNull((String)"userKey", (Object)userKey);
        Collection ownedPageIds = (Collection)this.cacheByUser.get((Object)userKey);
        ArrayList<PortalPage> returnPages = new ArrayList<PortalPage>(ownedPageIds.size());
        for (Long id : ownedPageIds) {
            PortalPage portalPage = this.getPortalPage(id);
            if (portalPage == null) continue;
            returnPages.add(portalPage);
        }
        return returnPages;
    }

    @Override
    public PortalPage getPortalPageByOwnerAndName(ApplicationUser owner, String portalPageName) {
        return this.delegateStore.getPortalPageByOwnerAndName(owner, portalPageName);
    }

    @Override
    public PortalPage getPortalPage(Long portalPageId) {
        Assertions.notNull((String)"portalPageId", (Object)portalPageId);
        return this.copyPortalPage((PortalPage)((CacheObject)this.cacheById.get((Object)portalPageId)).getValue());
    }

    @Override
    @SuppressWarnings(value={"UL_UNRELEASED_LOCK_EXCEPTION_PATH"}, justification="This appears to be doing exactly the right thing with the finally-clause to release the lock")
    public PortalPage create(PortalPage portalPage) {
        Assertions.notNull((String)"portalPage", (Object)portalPage);
        Assertions.notNull((String)"portalPage.name", (Object)portalPage.getName());
        Assertions.notNull((String)"portalPage.owner", (Object)portalPage.getOwner());
        PortalPage returnPage = null;
        try {
            returnPage = this.delegateStore.create(portalPage);
        }
        finally {
            if (returnPage != null) {
                this.cacheByUser.remove((Object)portalPage.getOwner().getKey());
                this.cacheById.remove((Object)returnPage.getId());
            }
        }
        return this.copyPortalPage(returnPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PortalPage update(PortalPage portalPage) {
        Assertions.notNull((String)"portalPage", (Object)portalPage);
        Assertions.notNull((String)"portalPage.id", (Object)portalPage.getId());
        ApplicationUser newOwner = portalPage.getOwner();
        if (!portalPage.isSystemDefaultPortalPage()) {
            Assertions.notNull((String)"portalPage.owner", (Object)newOwner);
        }
        PortalPage returnPage = null;
        PortalPage oldPortalPage = null;
        try {
            oldPortalPage = this.delegateStore.getPortalPage(portalPage.getId());
            returnPage = this.delegateStore.update(portalPage);
        }
        finally {
            this.cacheById.remove((Object)portalPage.getId());
            if (portalPage.getOwner() != null && (oldPortalPage == null || portalPage.getOwner() != oldPortalPage.getOwner())) {
                this.cacheByUser.remove((Object)portalPage.getOwner().getKey());
            }
            if (oldPortalPage != null && oldPortalPage.getOwner() != portalPage.getOwner()) {
                this.cacheByUser.remove((Object)oldPortalPage.getOwner().getKey());
            }
        }
        return returnPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updatePortalPageOptimisticLock(Long portalPageId, Long currentVersion) {
        Assertions.notNull((String)"portalPageId", (Object)portalPageId);
        Assertions.notNull((String)"currentVersion", (Object)currentVersion);
        try {
            boolean bl = this.delegateStore.updatePortalPageOptimisticLock(portalPageId, currentVersion);
            return bl;
        }
        finally {
            this.cacheById.remove((Object)portalPageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PortalPage adjustFavouriteCount(SharedEntity portalPage, int incrementValue) {
        Assertions.notNull((String)"portalPage", (Object)portalPage);
        Assertions.notNull((String)"portalPage.id", (Object)portalPage.getId());
        PortalPage returnPage = null;
        try {
            returnPage = this.delegateStore.adjustFavouriteCount(portalPage, incrementValue);
        }
        finally {
            this.cacheById.remove((Object)portalPage.getId());
        }
        return returnPage;
    }

    @Override
    public void delete(Long portalPageId) {
        Assertions.notNull((String)"portalPageId", (Object)portalPageId);
        PortalPage oldPage = null;
        try {
            oldPage = this.delegateStore.getPortalPage(portalPageId);
            this.delegateStore.delete(portalPageId);
        }
        finally {
            this.cacheById.remove((Object)portalPageId);
            if (oldPage != null && oldPage.getOwner() != null) {
                this.cacheByUser.remove((Object)oldPage.getOwner().getKey());
            }
        }
    }

    @Override
    public void flush() {
        this.cacheById.removeAll();
        this.cacheByUser.removeAll();
    }

    private PortalPage copyPortalPage(PortalPage portalPage) {
        return portalPage != null ? new PortalPage.Builder().portalPage(portalPage).build() : null;
    }

    private class ByIdCacheLoader
    implements CacheLoader<Long, CacheObject<PortalPage>> {
        private ByIdCacheLoader() {
        }

        public CacheObject<PortalPage> load(@Nonnull Long portalPageId) {
            return CacheObject.wrap(CachingPortalPageStore.this.delegateStore.getPortalPage(portalPageId));
        }
    }

    private class ByUserCacheLoader
    implements CacheLoader<String, List<Long>> {
        private ByUserCacheLoader() {
        }

        public List<Long> load(@Nonnull String ownerKey) {
            Collection<PortalPage> requestsFromDatabase = CachingPortalPageStore.this.delegateStore.getAllOwnedPortalPages(ownerKey);
            if (requestsFromDatabase != null) {
                ArrayList<Long> ownedPortalPageIds = new ArrayList<Long>(requestsFromDatabase.size());
                for (PortalPage PortalPage2 : requestsFromDatabase) {
                    ownedPortalPageIds.add(PortalPage2.getId());
                }
                return ImmutableList.copyOf(ownedPortalPageIds);
            }
            return ImmutableList.of();
        }
    }
}

