/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.project.ProjectImpl;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;

public class DefaultProjectFactory
implements ProjectFactory {
    final Function<GenericValue, Project> gvToProjectTransformer = new Function<GenericValue, Project>(){

        public Project get(GenericValue input) {
            return DefaultProjectFactory.this.getProject(input);
        }
    };

    @Nullable
    public Project getProject(@Nullable GenericValue projectGV) {
        if (projectGV == null) {
            return null;
        }
        return new ProjectImpl(projectGV);
    }

    @Nonnull
    public List<Project> getProjects(@Nonnull Collection<GenericValue> projectGVs) {
        Assertions.notNull((String)"projectGVs", projectGVs);
        return CollectionUtil.transform(projectGVs, this.gvToProjectTransformer);
    }
}

