/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.template.hook;

import com.atlassian.jira.project.template.hook.ScreenSchemeTemplate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Optional;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ScreenSchemeTemplateImpl
implements ScreenSchemeTemplate {
    private final String key;
    private final String name;
    private final String description;
    private final String defaultScreen;
    private final Optional<String> createScreen;
    private final Optional<String> editScreen;
    private final Optional<String> viewScreen;

    public ScreenSchemeTemplateImpl(@JsonProperty(value="key") String key, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="default-screen") String defaultScreen, @JsonProperty(value="create-screen") String createScreen, @JsonProperty(value="edit-screen") String editScreen, @JsonProperty(value="view-screen") String viewScreen) {
        this.key = ((String)Preconditions.checkNotNull((Object)key)).toUpperCase();
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.description = Strings.nullToEmpty((String)description);
        this.defaultScreen = ((String)Preconditions.checkNotNull((Object)defaultScreen)).toUpperCase();
        this.createScreen = ScreenSchemeTemplateImpl.toOptionalScreen(createScreen);
        this.editScreen = ScreenSchemeTemplateImpl.toOptionalScreen(editScreen);
        this.viewScreen = ScreenSchemeTemplateImpl.toOptionalScreen(viewScreen);
    }

    private static Optional<String> toOptionalScreen(String screenKey) {
        if (screenKey == null) {
            return Optional.empty();
        }
        return Optional.of(screenKey.toUpperCase());
    }

    public String key() {
        return this.key;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String defaultScreen() {
        return this.defaultScreen;
    }

    public Optional<String> createScreen() {
        return this.createScreen;
    }

    public Optional<String> editScreen() {
        return this.editScreen;
    }

    public Optional<String> viewScreen() {
        return this.viewScreen;
    }
}

