/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.type;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeUpdatedHandler;
import com.atlassian.jira.project.type.ProjectTypeUpdatedNotifier;
import com.atlassian.jira.project.type.ProjectTypeUpdatedOutcome;
import com.atlassian.jira.project.type.ProjectTypeUpdatedRegistrar;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectTypeUpdatedRegistrarImpl
implements ProjectTypeUpdatedRegistrar,
ProjectTypeUpdatedNotifier {
    private static final Logger log = LoggerFactory.getLogger(ProjectTypeUpdatedRegistrarImpl.class);
    protected final Map<String, ProjectTypeUpdatedHandler> handlers = new ConcurrentHashMap<String, ProjectTypeUpdatedHandler>();

    @Override
    public boolean notifyAllHandlers(ApplicationUser user, Project project, ProjectTypeKey oldProjectType, ProjectTypeKey newProjectType) {
        HashMap handlerResults = Maps.newHashMap();
        boolean handlersWereSuccessful = true;
        for (ProjectTypeUpdatedHandler handler : this.getHandlers()) {
            ProjectTypeUpdatedOutcome projectTypeUpdatedOutcome = handler.onProjectTypeUpdated(user, project, oldProjectType, newProjectType);
            handlerResults.put(handler, projectTypeUpdatedOutcome);
            if (projectTypeUpdatedOutcome.isSuccessful()) continue;
            log.error("The handler with id " + handler.getHandlerId() + " failed while handling a notification about a project type update");
            handlersWereSuccessful = false;
            break;
        }
        if (!handlersWereSuccessful) {
            handlerResults.entrySet().forEach(handlerResult -> {
                ProjectTypeUpdatedHandler handler = (ProjectTypeUpdatedHandler)handlerResult.getKey();
                ProjectTypeUpdatedOutcome outcome = (ProjectTypeUpdatedOutcome)handlerResult.getValue();
                handler.onProjectTypeUpdateRolledBack(user, project, oldProjectType, newProjectType, outcome);
            });
        }
        return handlersWereSuccessful;
    }

    @VisibleForTesting
    protected Collection<ProjectTypeUpdatedHandler> getHandlers() {
        return this.handlers.values();
    }

    public void register(ProjectTypeUpdatedHandler handlerToAdd) {
        this.handlers.put(handlerToAdd.getHandlerId(), handlerToAdd);
    }

    public void unregister(ProjectTypeUpdatedHandler handlerToRemove) {
        this.handlers.remove(handlerToRemove.getHandlerId());
    }
}

