/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.propertyset;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheException;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.propertyset.OfBizPropertyEntryStore;
import com.atlassian.jira.propertyset.OfBizPropertyTypeRegistry;
import com.atlassian.jira.propertyset.PropertySetEntity;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.CacheObject;
import com.google.common.collect.ImmutableSet;
import com.opensymphony.module.propertyset.PropertyImplementationException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@EventComponent
public class CachingOfBizPropertyEntryStore
implements OfBizPropertyEntryStore {
    private final DelegatorInterface genericDelegator;
    final Cache<CacheKey, CacheObject<OfBizPropertyEntryStore.PropertyEntry>> entries;

    public CachingOfBizPropertyEntryStore(DelegatorInterface genericDelegator, CacheManager cacheManager) {
        this.genericDelegator = (DelegatorInterface)Assertions.notNull((String)"genericDelegator", (Object)genericDelegator);
        this.entries = cacheManager.getCache(CachingOfBizPropertyEntryStore.class.getName() + ".entries", (CacheLoader)new EntryLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    @Override
    public Collection<String> getKeys(String entityName, long entityId) {
        return this.getKeys(FieldMap.build((String)"entityName", (Object)entityName, (String)"entityId", (Object)entityId));
    }

    @Override
    public Collection<String> getKeys(String entityName, long entityId, int type) {
        return this.getKeys(FieldMap.build((String)"entityName", (Object)entityName, (String)"entityId", (Object)entityId, (String)"type", (Object)type));
    }

    private Collection<String> getKeys(FieldMap fieldMap) {
        try {
            EntityFieldMap condition = new EntityFieldMap((Map)fieldMap, EntityOperator.AND);
            List keyGVs = this.genericDelegator.findByCondition("OSPropertyEntry", (EntityCondition)condition, PropertySetEntity.SELECT_KEY, null);
            if (keyGVs == null || keyGVs.isEmpty()) {
                return ImmutableSet.of();
            }
            HashSet<String> keys = new HashSet<String>(keyGVs.size());
            for (GenericValue keyGV : keyGVs) {
                keys.add(keyGV.getString("propertyKey"));
            }
            return keys;
        }
        catch (GenericEntityException gee) {
            throw new PropertyImplementationException((Throwable)gee);
        }
    }

    @Override
    public OfBizPropertyEntryStore.PropertyEntry getEntry(String entityName, long entityId, String propertyKey) {
        try {
            return (OfBizPropertyEntryStore.PropertyEntry)((CacheObject)this.entries.get((Object)new CacheKey(entityName, entityId, propertyKey))).getValue();
        }
        catch (CacheException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new PropertyImplementationException(cause != null ? cause : ex);
        }
    }

    @Override
    public void setEntry(String entityName, long entityId, String propertyKey, int type, Object value) {
        CacheKey cacheKey = new CacheKey(entityName, entityId, propertyKey);
        try {
            this.setEntryImpl(cacheKey, type, value);
        }
        catch (GenericEntityException gee) {
            throw new PropertyImplementationException((Throwable)gee);
        }
        finally {
            this.entries.remove((Object)cacheKey);
        }
    }

    @Override
    public void removeEntry(String entityName, long entityId, String propertyKey) {
        EntityFieldMap condition = new EntityFieldMap((Map)FieldMap.build((String)"entityName", (Object)entityName, (String)"entityId", (Object)entityId, (String)"propertyKey", (Object)propertyKey), EntityOperator.AND);
        try {
            List list = this.genericDelegator.findByCondition("OSPropertyEntry", (EntityCondition)condition, PropertySetEntity.SELECT_ID_AND_TYPE, null);
            if (list != null) {
                for (GenericValue entry : list) {
                    this.removeEntryAndValue(entry);
                }
            }
        }
        catch (GenericEntityException gee) {
            throw new PropertyImplementationException((Throwable)gee);
        }
        finally {
            this.invalidateCacheEntry(entityName, entityId, propertyKey);
        }
    }

    @Override
    public void removePropertySet(String entityName, long entityId) {
        EntityFieldMap condition = new EntityFieldMap((Map)FieldMap.build((String)"entityName", (Object)entityName, (String)"entityId", (Object)entityId), EntityOperator.AND);
        try {
            List list = this.genericDelegator.findByCondition("OSPropertyEntry", (EntityCondition)condition, PropertySetEntity.SELECT_ID_KEY_AND_TYPE, null);
            if (list != null && !list.isEmpty()) {
                for (GenericValue entry : list) {
                    this.removeEntryAndValue(entry);
                    this.invalidateCacheEntry(entityName, entityId, entry.getString("propertyKey"));
                }
            }
        }
        catch (GenericEntityException gee) {
            throw new PropertyImplementationException((Throwable)gee);
        }
    }

    private void setEntryImpl(CacheKey cacheKey, Integer type, Object unmappedValue) throws GenericEntityException {
        GenericValue propertyEntry = this.makeUpdatedEntry(cacheKey, type);
        OfBizPropertyTypeRegistry.TypeMapper mapper = OfBizPropertyTypeRegistry.mapper(type);
        Object mappedValue = unmappedValue != null ? mapper.getHandler().processSet(type.intValue(), unmappedValue) : null;
        GenericValue propertyTypeEntry = this.genericDelegator.makeValue(mapper.getEntityName(), (Map)FieldMap.build((String)"id", (Object)propertyEntry.getLong("id"), (String)"value", (Object)mappedValue));
        this.genericDelegator.storeAll(Arrays.asList(propertyEntry, propertyTypeEntry));
    }

    private GenericValue makeUpdatedEntry(CacheKey cacheKey, Integer type) throws GenericEntityException {
        FieldMap fieldMap = cacheKey.toFieldMap();
        List list = this.genericDelegator.findByAnd("OSPropertyEntry", (Map)fieldMap);
        if (list == null || list.isEmpty()) {
            Long id = this.genericDelegator.getNextSeqId("OSPropertyEntry");
            return this.genericDelegator.makeValue("OSPropertyEntry", (Map)fieldMap.add("id", (Object)id).add("type", (Object)type));
        }
        GenericValue existingPropertyEntry = list.size() == 1 ? (GenericValue)list.get(0) : this.selectMaximumIdAndRemoveOthers(list);
        this.removeOrphanedValueIfTypeChanged(type, existingPropertyEntry);
        return existingPropertyEntry;
    }

    private void removeOrphanedValueIfTypeChanged(Integer newType, GenericValue existingPropertyEntry) throws GenericEntityException {
        Integer oldType = existingPropertyEntry.getInteger("type");
        if (oldType.equals(newType)) {
            return;
        }
        OfBizPropertyTypeRegistry.TypeMapper newMapper = OfBizPropertyTypeRegistry.mapper(newType);
        OfBizPropertyTypeRegistry.TypeMapper oldMapper = OfBizPropertyTypeRegistry.mapper(oldType);
        if (!oldMapper.hasSameEntityName(newMapper)) {
            this.genericDelegator.removeByAnd(oldMapper.getEntityName(), (Map)FieldMap.build((String)"id", (Object)existingPropertyEntry.getLong("id")));
        }
        existingPropertyEntry.set("type", (Object)newType);
    }

    private void removeEntryAndValue(GenericValue entry) throws GenericEntityException {
        this.removeEntryAndValue(entry.getLong("id"), entry.getInteger("type"));
    }

    private void removeEntryAndValue(Long id, Integer type) throws GenericEntityException {
        FieldMap byId = FieldMap.build((String)"id", (Object)id);
        this.genericDelegator.removeByAnd(OfBizPropertyTypeRegistry.mapper(type).getEntityName(), (Map)byId);
        this.genericDelegator.removeByAnd("OSPropertyEntry", (Map)byId);
    }

    private void invalidateCacheEntry(String entityName, long entityId, String propertyKey) {
        this.entries.remove((Object)new CacheKey(entityName, entityId, propertyKey));
    }

    private static GenericValue selectMaximumId(@Nonnull List<GenericValue> list) {
        Iterator<GenericValue> iter = list.iterator();
        GenericValue winner = iter.next();
        long winnerId = winner.getLong("id");
        do {
            GenericValue other;
            long otherId;
            if ((otherId = (other = iter.next()).getLong("id").longValue()) <= winnerId) continue;
            winner = other;
            winnerId = otherId;
        } while (iter.hasNext());
        return winner;
    }

    private GenericValue selectMaximumIdAndRemoveOthers(@Nonnull List<GenericValue> list) throws GenericEntityException {
        GenericValue winner = CachingOfBizPropertyEntryStore.selectMaximumId(list);
        for (GenericValue other : list) {
            if (other == winner) continue;
            this.removeEntryAndValue(other);
        }
        return winner;
    }

    public void refreshAll() {
        this.entries.removeAll();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refreshAll();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024).append(this.getClass().getSimpleName()).append("[entries={");
        Collection keys = this.entries.getKeys();
        if (!keys.isEmpty()) {
            for (CacheKey key : keys) {
                sb.append("\n\t").append(key).append(" => ").append(this.entries.get((Object)key)).append(',');
            }
            sb.setCharAt(sb.length() - 1, '\n');
        }
        return sb.append("}]").toString();
    }

    class EntryLoader
    implements CacheLoader<CacheKey, CacheObject<OfBizPropertyEntryStore.PropertyEntry>> {
        EntryLoader() {
        }

        public CacheObject<OfBizPropertyEntryStore.PropertyEntry> load(@Nonnull CacheKey cacheKey) {
            try {
                List list = CachingOfBizPropertyEntryStore.this.genericDelegator.findByCondition("OSPropertyEntry", (EntityCondition)cacheKey.toCondition(), PropertySetEntity.SELECT_ID_AND_TYPE, null);
                if (list == null || list.isEmpty()) {
                    return CacheObject.NULL();
                }
                GenericValue entry = list.size() == 1 ? (GenericValue)list.get(0) : CachingOfBizPropertyEntryStore.selectMaximumId(list);
                return this.buildPropertyEntry(entry);
            }
            catch (GenericEntityException gee) {
                throw new PropertyImplementationException((Throwable)gee);
            }
        }

        private CacheObject<OfBizPropertyEntryStore.PropertyEntry> buildPropertyEntry(GenericValue entry) throws GenericEntityException {
            Long id = entry.getLong("id");
            Integer type = entry.getInteger("type");
            GenericValue genericValue = CachingOfBizPropertyEntryStore.this.genericDelegator.findByPrimaryKey(OfBizPropertyTypeRegistry.mapper(type).getEntityName(), (Map)FieldMap.build((String)"id", (Object)id));
            Object value = genericValue != null ? genericValue.get("value") : null;
            return CacheObject.wrap(new PropertyEntryImpl(type, value));
        }
    }

    static class PropertyEntryImpl
    implements OfBizPropertyEntryStore.PropertyEntry {
        private final int type;
        private final Object value;

        PropertyEntryImpl(int type, Object value) {
            this.type = type;
            this.value = value;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        @Nullable
        public Object getValue() {
            if (this.value == null) {
                return null;
            }
            return OfBizPropertyTypeRegistry.mapper(this.type).getHandler().processGet(this.type, this.value);
        }

        @Override
        @Nullable
        public Object getValue(int type) {
            if (this.value == null) {
                return null;
            }
            return OfBizPropertyTypeRegistry.mapper(type).getHandler().processGet(type, this.value);
        }

        public String toString() {
            return "PropertyEntryImpl[type=" + this.type + ",value=" + this.value + ']';
        }
    }

    static class CacheKey
    implements Serializable {
        private static final long serialVersionUID = 2594159095924513835L;
        private final String entityName;
        private final long entityId;
        private final String propertyKey;

        CacheKey(String entityName, long entityId, String propertyKey) {
            this.entityName = entityName;
            this.entityId = entityId;
            this.propertyKey = propertyKey;
        }

        String getEntityName() {
            return this.entityName;
        }

        long getEntityId() {
            return this.entityId;
        }

        String getPropertyKey() {
            return this.propertyKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            return this.entityId == other.entityId && this.entityName.equals(other.entityName) && this.propertyKey.equals(other.propertyKey);
        }

        public int hashCode() {
            int result = this.entityName.hashCode();
            result = 31 * result + (int)(this.entityId ^ this.entityId >>> 32);
            result = 31 * result + this.propertyKey.hashCode();
            return result;
        }

        public String toString() {
            return "CacheKey[entityName=" + this.entityName + ",entityId=" + this.entityId + ",propertyKey=" + this.propertyKey + ']';
        }

        public FieldMap toFieldMap() {
            return FieldMap.build((String)"entityName", (Object)this.entityName, (String)"entityId", (Object)this.entityId, (String)"propertyKey", (Object)this.propertyKey);
        }

        public EntityFieldMap toCondition() {
            return new EntityFieldMap((Map)this.toFieldMap(), EntityOperator.AND);
        }
    }
}

