/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.propertyset;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.propertyset.OfBizPropertyEntryStore;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.Supplier;
import com.atlassian.util.concurrent.Suppliers;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.module.propertyset.AbstractPropertySet;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertyImplementationException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class CachingOfBizPropertySet
extends AbstractPropertySet
implements Serializable {
    private static final long serialVersionUID = -5171154172922195519L;
    private transient Supplier<OfBizPropertyEntryStore> entryStoreRef;
    private volatile Entity entity;

    public CachingOfBizPropertySet() {
        this.entryStoreRef = ComponentAccessor.getComponentReference(OfBizPropertyEntryStore.class);
    }

    public CachingOfBizPropertySet(String entityName, Long entityId) {
        this.entryStoreRef = ComponentAccessor.getComponentReference(OfBizPropertyEntryStore.class);
        this.entity = new Entity(entityName, entityId);
    }

    CachingOfBizPropertySet(OfBizPropertyEntryStore entryStore, String entityName, Long entityId) {
        this.entryStoreRef = Suppliers.memoize((Object)entryStore);
        this.entity = new Entity(entityName, entityId);
    }

    public List<String> getKeys() {
        Entity entity = this.entity;
        return CachingOfBizPropertySet.sorted(this.getEntryStore().getKeys(entity.entityName, entity.entityId));
    }

    public List<String> getKeys(String prefix) {
        Entity entity = this.entity;
        return CachingOfBizPropertySet.sorted(Iterables.filter(this.getEntryStore().getKeys(entity.entityName, entity.entityId), (Predicate)new StartsWith(prefix)));
    }

    public List<String> getKeys(int type) {
        Entity entity = this.entity;
        return CachingOfBizPropertySet.sorted(this.getEntryStore().getKeys(entity.entityName, entity.entityId, type));
    }

    public List<String> getKeys(String prefix, int type) {
        Entity entity = this.entity;
        return CachingOfBizPropertySet.sorted(Iterables.filter(this.getEntryStore().getKeys(entity.entityName, entity.entityId, type), (Predicate)new StartsWith(prefix)));
    }

    private static List<String> sorted(Iterable<String> keys) {
        ArrayList sortedKeys = Lists.newArrayList(keys);
        Collections.sort(sortedKeys);
        return sortedKeys;
    }

    public int getType(String key) throws PropertyException {
        Entity entity = this.entity;
        OfBizPropertyEntryStore.PropertyEntry entry = this.getEntryStore().getEntry(entity.entityName, entity.entityId, key);
        if (entry == null) {
            throw new PropertyImplementationException("Property '" + key + "' not found");
        }
        return entry.getType();
    }

    public boolean exists(String key) throws PropertyException {
        Entity entity = this.entity;
        return this.getEntryStore().getEntry(entity.entityName, entity.entityId, key) != null;
    }

    public void init(Map config, Map args) {
        String entityName = (String)args.get("entityName");
        Long entityId = (Long)args.get("entityId");
        this.entity = new Entity(entityName, entityId);
    }

    public void remove() throws PropertyException {
        Entity entity = this.entity;
        this.getEntryStore().removePropertySet(entity.entityName, entity.entityId);
    }

    public void remove(String key) {
        Entity entity = this.entity;
        this.getEntryStore().removeEntry(entity.entityName, entity.entityId, key);
    }

    public boolean supportsType(int type) {
        return true;
    }

    protected void setImpl(int type, String key, Object obj) {
        Entity entity = this.entity;
        this.getEntryStore().setEntry(entity.entityName, entity.entityId, key, type, obj);
    }

    @Nullable
    protected Object get(int type, String key) {
        Entity entity = this.entity;
        OfBizPropertyEntryStore.PropertyEntry entry = this.getEntryStore().getEntry(entity.entityName, entity.entityId, key);
        return entry != null ? entry.getValue(type) : null;
    }

    @VisibleForTesting
    OfBizPropertyEntryStore getEntryStore() {
        return (OfBizPropertyEntryStore)this.entryStoreRef.get();
    }

    public boolean equals(Object o) {
        return o instanceof CachingOfBizPropertySet && Objects.equal((Object)this.entity, (Object)((CachingOfBizPropertySet)o).entity);
    }

    public int hashCode() {
        Entity entity = this.entity;
        return entity != null ? entity.hashCode() : 0;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.entity);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.entryStoreRef = ComponentAccessor.getComponentReference(OfBizPropertyEntryStore.class);
        this.entity = (Entity)in.readObject();
    }

    static class StartsWith
    implements Predicate<String> {
        private final String prefix;

        StartsWith(String prefix) {
            this.prefix = prefix != null ? prefix : "";
        }

        public boolean apply(@Nullable String s) {
            return s != null && s.startsWith(this.prefix);
        }
    }

    static class Entity
    implements Serializable {
        private static final long serialVersionUID = -9043112541417402302L;
        final String entityName;
        final long entityId;

        Entity(String entityName, Long entityId) {
            this.entityName = (String)Assertions.notNull((String)"entityName", (Object)entityName);
            this.entityId = (Long)Assertions.notNull((String)"entityId", (Object)entityId);
        }

        public boolean equals(Object o) {
            return o instanceof Entity && this.equals((Entity)o);
        }

        private boolean equals(Entity other) {
            return this.entityId == other.entityId && this.entityName.equals(other.entityName);
        }

        public int hashCode() {
            return 31 * this.entityName.hashCode() + (int)(this.entityId ^ this.entityId >>> 32);
        }
    }
}

