/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheduler;

import com.atlassian.jira.scheduler.OfBizRunDetailsDao;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.caesium.impl.CaesiumSchedulerService;
import com.atlassian.scheduler.caesium.spi.CaesiumSchedulerConfiguration;
import com.atlassian.scheduler.caesium.spi.ClusteredJobDao;
import com.atlassian.scheduler.core.spi.RunDetailsDao;
import com.atlassian.tenancy.api.Tenant;
import com.atlassian.tenancy.api.TenantAccessor;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class JiraCaesiumSchedulerService
extends CaesiumSchedulerService {
    private static final Logger LOG = Logger.getLogger(JiraCaesiumSchedulerService.class);
    private final RunDetailsDao runDetailsDao;

    public JiraCaesiumSchedulerService(RunDetailsDao runDetailsDao, CaesiumSchedulerConfiguration config, ClusteredJobDao clusteredJobDao, TenantAccessor tenantAccessor) throws SchedulerServiceException {
        super(config, (TenantAccessor)new FakeTenantAccessor(), runDetailsDao, clusteredJobDao);
        this.runDetailsDao = runDetailsDao;
    }

    protected void startImpl() throws SchedulerServiceException {
        boolean ok = false;
        try {
            this.startRunDetailsDao();
            super.startImpl();
            ok = true;
        }
        finally {
            if (!ok) {
                this.stopRunDetailsDao();
            }
        }
    }

    protected void standbyImpl() throws SchedulerServiceException {
        super.standbyImpl();
        this.stopRunDetailsDao();
    }

    protected void shutdownImpl() {
        super.shutdownImpl();
        this.stopRunDetailsDao();
    }

    public void preJob() {
        JiraThreadLocalUtils.preCall();
    }

    public void postJob() {
        JiraThreadLocalUtils.postCall(LOG, null);
    }

    private void startRunDetailsDao() {
        if (this.runDetailsDao instanceof OfBizRunDetailsDao) {
            ((OfBizRunDetailsDao)this.runDetailsDao).start();
        }
    }

    private void stopRunDetailsDao() {
        if (this.runDetailsDao instanceof OfBizRunDetailsDao) {
            ((OfBizRunDetailsDao)this.runDetailsDao).stop();
        }
    }

    static class FakeTenant
    implements Tenant {
        FakeTenant() {
        }
    }

    static class FakeTenantAccessor
    implements TenantAccessor {
        private static final List<Tenant> TENANTS = ImmutableList.of((Object)new FakeTenant());

        FakeTenantAccessor() {
        }

        public Iterable<Tenant> getAvailableTenants() {
            return TENANTS;
        }

        public <T> T asTenant(Tenant tenant, Callable<T> callable) {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

