/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.LegacyProjectPermissionKeyMapping;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.WorkflowPermission;
import com.atlassian.jira.permission.WorkflowPermissionFactory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.DefaultPermissionManager;
import com.atlassian.jira.security.ProjectPermissionOverrideDescriptorCache;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.plugin.ProjectPermissionTypesManager;
import com.atlassian.jira.user.ApplicationUser;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowBasedPermissionManager
extends DefaultPermissionManager {
    private static final Logger log = LoggerFactory.getLogger(WorkflowBasedPermissionManager.class);
    private final WorkflowPermissionFactory workflowPermissionFactory;
    private final PermissionContextFactory permissionContextFactory;

    public WorkflowBasedPermissionManager(WorkflowPermissionFactory workflowPermissionFactory, PermissionContextFactory permissionContextFactory, ProjectPermissionTypesManager projectPermissionTypesManager, ProjectPermissionOverrideDescriptorCache projectPermissionOverrideDescriptorCache) {
        super(projectPermissionTypesManager, projectPermissionOverrideDescriptorCache);
        this.workflowPermissionFactory = workflowPermissionFactory;
        this.permissionContextFactory = permissionContextFactory;
    }

    @Override
    public boolean hasPermission(int permissionsId, Issue issue, ApplicationUser user) {
        boolean permSchemeAllows = super.hasPermission(permissionsId, issue, user);
        return this.workflowPermissionCheck(permSchemeAllows, permissionsId, issue, user);
    }

    @Override
    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionsKey, @Nonnull Issue issue, ApplicationUser user) {
        boolean permSchemeAllows = super.hasPermission(permissionsKey, issue, user);
        return this.workflowPermissionCheck(permSchemeAllows, permissionsKey, issue, user);
    }

    @Override
    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Issue issue, @Nullable ApplicationUser user, @Nullable ActionDescriptor actionDescriptor) {
        boolean permSchemeAllows = super.hasPermission(permissionKey, issue, user);
        return this.workflowPermissionCheck(permSchemeAllows, permissionKey, issue, user, actionDescriptor);
    }

    @Override
    public boolean hasPermission(int permissionsId, Project project, ApplicationUser user) {
        boolean permSchemeAllows = super.hasPermission(permissionsId, project, user);
        return this.workflowPermissionCheck(permSchemeAllows, permissionsId, project.getGenericValue(), user);
    }

    @Override
    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionsKey, @Nonnull Project project, @Nullable ApplicationUser user) {
        boolean permSchemeAllows = super.hasPermission(permissionsKey, project, user);
        return this.workflowPermissionCheck(permSchemeAllows, permissionsKey, this.getIssueOrNull(project.getGenericValue()), user);
    }

    @Override
    public boolean hasPermission(int permissionsId, Project project, ApplicationUser user, boolean issueCreation) {
        boolean permSchemeAllows = super.hasPermission(permissionsId, project, user, issueCreation);
        return this.workflowPermissionCheck(permSchemeAllows, permissionsId, project.getGenericValue(), user);
    }

    @Override
    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionsKey, @Nonnull Project project, ApplicationUser user, boolean issueCreation) {
        boolean permSchemeAllows = super.hasPermission(permissionsKey, project, user, issueCreation);
        return this.workflowPermissionCheck(permSchemeAllows, permissionsKey, this.getIssueOrNull(project.getGenericValue()), user);
    }

    private boolean workflowPermissionCheck(boolean permissionSchemeAllows, int permissionId, GenericValue entity, ApplicationUser user) {
        ProjectPermissionKey permissionKey = LegacyProjectPermissionKeyMapping.getKey(permissionId);
        return this.workflowPermissionCheck(permissionSchemeAllows, permissionKey, this.getIssueOrNull(entity), user);
    }

    private boolean workflowPermissionCheck(boolean permissionSchemeAllows, int permissionId, Issue issue, ApplicationUser user) {
        ProjectPermissionKey permissionKey = LegacyProjectPermissionKeyMapping.getKey(permissionId);
        return this.workflowPermissionCheck(permissionSchemeAllows, permissionKey, issue, user);
    }

    private boolean workflowPermissionCheck(boolean permissionSchemeAllows, ProjectPermissionKey permissionKey, Issue issue, ApplicationUser user) {
        return this.workflowPermissionCheck(permissionSchemeAllows, permissionKey, issue, user, null);
    }

    private boolean workflowPermissionCheck(boolean permissionSchemeAllows, ProjectPermissionKey permissionKey, Issue issue, ApplicationUser user, @Nullable ActionDescriptor actionDescriptor) {
        if (permissionKey == null) {
            return permissionSchemeAllows;
        }
        if (permissionSchemeAllows) {
            if (issue != null) {
                List<WorkflowPermission> workflowPerms = this.workflowPermissionFactory.getWorkflowPermissions(this.permissionContextFactory.getPermissionContext(issue, actionDescriptor), permissionKey, false);
                this.addParentPermissionsIfSubTask(workflowPerms, issue, permissionKey);
                if (!workflowPerms.isEmpty()) {
                    for (WorkflowPermission permission : workflowPerms) {
                        if (permission.allows(permissionKey, issue, user)) {
                            if (log.isInfoEnabled()) {
                                log.info(permissionKey.permissionKey() + " granted by permission scheme and " + permission);
                            }
                            return true;
                        }
                        if (!log.isInfoEnabled()) continue;
                        log.info("\t" + permissionKey.permissionKey() + " not granted by " + permission);
                    }
                    if (log.isInfoEnabled()) {
                        log.info(permissionKey.permissionKey() + " granted by permission scheme but DENIED by workflow");
                    }
                    return false;
                }
                if (log.isDebugEnabled()) {
                    log.debug(permissionKey.permissionKey() + " granted by permission scheme");
                }
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug(permissionKey.permissionKey() + " permission granted by permission scheme");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug(permissionKey.permissionKey() + " permission denied by permission scheme");
        }
        return false;
    }

    private Issue getIssueOrNull(GenericValue entity) {
        if (entity != null && "Issue".equals(entity.getEntityName())) {
            return ComponentAccessor.getIssueFactory().getIssue(entity);
        }
        return null;
    }

    private void addParentPermissionsIfSubTask(List<WorkflowPermission> workflowPerms, Issue issue, ProjectPermissionKey permissionId) {
        SubTaskManager subTaskManager = ComponentAccessor.getSubTaskManager();
        Issue parent = issue.getParentObject();
        if (subTaskManager.isSubTasksEnabled() && parent != null) {
            PermissionContext parentPermissionContext = this.permissionContextFactory.getPermissionContext(parent);
            workflowPerms.addAll(this.workflowPermissionFactory.getWorkflowPermissions(parentPermissionContext, permissionId, true));
        }
    }
}

