/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.groups;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.jira.cache.request.RequestCache;
import com.atlassian.jira.cache.request.RequestCacheFactory;
import com.atlassian.jira.security.groups.DefaultGroupManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;

public class RequestCachingGroupManager
implements GroupManager {
    private static final String USERNAME_TO_GROUP_NAMES_CACHE_KEY = RequestCachingGroupManager.class.getName() + ".usernameToGroupNames";
    private static final String USERNAME_TO_GROUPS_CACHE_KEY = RequestCachingGroupManager.class.getName() + ".usernameToGroups";
    private static final String USERNAME_TO_GROUP_NAMES_LOWER_CASE_CACHE_KEY = RequestCachingGroupManager.class.getName() + ".usernameToGroupNamesInLowerCase";
    private final DefaultGroupManager defaultGroupManager;
    private final RequestCache<String, Set<Group>> usernameToGroups;
    private final RequestCache<String, Set<String>> usernameToGroupNames;
    private final RequestCache<String, Set<String>> usernameToGroupNamesInLowerCase;

    public RequestCachingGroupManager(DefaultGroupManager defaultGroupManager, RequestCacheFactory requestCacheFactory) {
        this.defaultGroupManager = defaultGroupManager;
        this.usernameToGroups = requestCacheFactory.createRequestCache(USERNAME_TO_GROUPS_CACHE_KEY, username -> ImmutableSet.copyOf(defaultGroupManager.getGroupsForUser((String)username)));
        this.usernameToGroupNames = requestCacheFactory.createRequestCache(USERNAME_TO_GROUP_NAMES_CACHE_KEY, username -> (ImmutableSet)((Set)this.usernameToGroups.get(username)).stream().map(Group::getName).collect(CollectorsUtil.toImmutableSet()));
        this.usernameToGroupNamesInLowerCase = requestCacheFactory.createRequestCache(USERNAME_TO_GROUP_NAMES_LOWER_CASE_CACHE_KEY, username -> (ImmutableSet)((Set)this.usernameToGroupNames.get(username)).stream().map(IdentifierUtils::toLowerCase).collect(CollectorsUtil.toImmutableSet()));
    }

    public boolean groupExists(String groupName) {
        return this.defaultGroupManager.groupExists(groupName);
    }

    public boolean groupExists(@Nonnull Group group) {
        return this.defaultGroupManager.groupExists(group);
    }

    public Collection<Group> getAllGroups() {
        return this.defaultGroupManager.getAllGroups();
    }

    public Group createGroup(String groupName) throws OperationNotPermittedException, InvalidGroupException {
        return this.defaultGroupManager.createGroup(groupName);
    }

    public Group getGroup(String groupName) {
        return this.defaultGroupManager.getGroup(groupName);
    }

    public Group getGroupEvenWhenUnknown(String groupName) {
        return this.defaultGroupManager.getGroupEvenWhenUnknown(groupName);
    }

    public Group getGroupObject(String groupName) {
        return this.defaultGroupManager.getGroupObject(groupName);
    }

    public boolean isUserInGroup(String username, String groupname) {
        if (username == null || groupname == null) {
            return this.defaultGroupManager.isUserInGroup(username, groupname);
        }
        Set groupNamesInLowerCase = (Set)this.usernameToGroupNamesInLowerCase.get((Object)username);
        return groupNamesInLowerCase.contains(IdentifierUtils.toLowerCase((String)groupname));
    }

    public boolean isUserInGroup(ApplicationUser user, Group group) {
        if (user == null || group == null) {
            return this.defaultGroupManager.isUserInGroup(user, group);
        }
        return this.isUserInGroup(user.getName(), group.getName());
    }

    public boolean isUserInGroup(ApplicationUser user, String groupName) {
        if (user == null) {
            return this.defaultGroupManager.isUserInGroup(user, groupName);
        }
        return this.isUserInGroup(user.getName(), groupName);
    }

    public Collection<ApplicationUser> getUsersInGroup(String groupName) {
        return this.defaultGroupManager.getUsersInGroup(groupName);
    }

    public Collection<ApplicationUser> getUsersInGroup(String groupName, Boolean includeInactive) {
        return this.defaultGroupManager.getUsersInGroup(groupName, includeInactive);
    }

    public Page<ApplicationUser> getUsersInGroup(String groupName, Boolean includeInactive, PageRequest pageRequest) {
        return this.defaultGroupManager.getUsersInGroup(groupName, includeInactive, pageRequest);
    }

    public Collection<ApplicationUser> getUsersInGroup(Group group) {
        return this.defaultGroupManager.getUsersInGroup(group);
    }

    public int getUsersInGroupCount(Group group) {
        return this.defaultGroupManager.getUsersInGroupCount(group);
    }

    public int getUsersInGroupCount(String groupName) {
        return this.defaultGroupManager.getUsersInGroupCount(groupName);
    }

    public Collection<String> getNamesOfDirectMembersOfGroups(Collection<String> groupNames, int limit) {
        return this.defaultGroupManager.getNamesOfDirectMembersOfGroups((Collection)groupNames, limit);
    }

    public Collection<String> filterUsersInAllGroupsDirect(Collection<String> userNames, Collection<String> groupNames) {
        return this.defaultGroupManager.filterUsersInAllGroupsDirect(userNames, groupNames);
    }

    public Collection<String> getUserNamesInGroup(Group group) {
        return this.defaultGroupManager.getUserNamesInGroup(group);
    }

    public Collection<String> getUserNamesInGroups(Collection<Group> groups) {
        return this.defaultGroupManager.getUserNamesInGroups(groups);
    }

    public Collection<String> getUserNamesInGroup(String groupName) {
        return this.defaultGroupManager.getUserNamesInGroup(groupName);
    }

    public Collection<ApplicationUser> getDirectUsersInGroup(Group group) {
        return this.defaultGroupManager.getDirectUsersInGroup(group);
    }

    public Collection<Group> getGroupsForUser(String userName) {
        return (Collection)this.usernameToGroups.get((Object)userName);
    }

    public Collection<Group> getGroupsForUser(@Nonnull ApplicationUser user) {
        return this.getGroupsForUser(user.getName());
    }

    public Collection<String> getGroupNamesForUser(String userName) {
        return (Collection)this.usernameToGroupNames.get((Object)userName);
    }

    public Collection<String> getGroupNamesForUser(@Nonnull ApplicationUser user) {
        return this.getGroupNamesForUser(user.getName());
    }

    public void addUserToGroup(ApplicationUser user, Group group) throws GroupNotFoundException, UserNotFoundException, OperationNotPermittedException, OperationFailedException {
        this.defaultGroupManager.addUserToGroup(user, group);
    }
}

