/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.template.velocity;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.util.concurrent.LazyReference;
import java.util.Properties;
import org.apache.velocity.app.VelocityEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface VelocityEngineFactory {
    public VelocityEngine getEngine();

    public static class Default
    implements VelocityEngineFactory {
        private static final Logger log = LoggerFactory.getLogger(Default.class);
        @ClusterSafe(value="Program artifacts only.")
        private final LazyReference<VelocityEngine> velocityEngine = new LazyReference<VelocityEngine>(){

            protected VelocityEngine create() throws Exception {
                VelocityEngine result = new VelocityEngine();
                this.initialise(result);
                return result;
            }
        };

        @Override
        public VelocityEngine getEngine() {
            return (VelocityEngine)this.velocityEngine.get();
        }

        private void initialise(VelocityEngine velocityEngine) {
            try {
                Properties velocityPropertiesFile = new Properties();
                try {
                    velocityPropertiesFile.load(ClassLoaderUtils.getResourceAsStream((String)"velocity.properties", this.getClass()));
                }
                catch (Exception e) {
                    log.warn("Could not configure the Velocity Engine from the velocity.properties, manually configuring.");
                    velocityPropertiesFile.put("resource.loader", "class");
                    velocityPropertiesFile.put("class.resource.loader.description", "Velocity Classpath Resource Loader");
                    velocityPropertiesFile.put("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
                }
                Default.enableDevMode(velocityPropertiesFile);
                velocityEngine.init(velocityPropertiesFile);
            }
            catch (Exception e) {
                log.error("Exception initialising Velocity: " + e, (Throwable)e);
            }
        }

        public static void enableDevMode(Properties velocityPropertiesFile) {
            if (JiraSystemProperties.isDevMode()) {
                velocityPropertiesFile.put("class.resource.loader.cache", "false");
                velocityPropertiesFile.put("velocimacro.library.autoreload", "true");
                velocityPropertiesFile.put("plugin.resource.loader.cache", "false");
            }
        }
    }
}

