/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.template.velocity;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cache.GoogleCacheInstruments;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.velocity.htmlsafe.directive.DefaultDirectiveChecker;
import com.atlassian.velocity.htmlsafe.directive.DirectiveChecker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.velocity.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class VelocityTemplateCache
implements Startable {
    private static final Logger log = LoggerFactory.getLogger(VelocityTemplateCache.class);
    private static final int MAX_ENTRIES = 5000;
    private final DirectiveChecker directiveChecker;
    private final LoadingCache<Template, TemplateInfo> cache = CacheBuilder.newBuilder().weakKeys().maximumSize(5000L).removalListener((RemovalListener)new TemplateInfoRemovalListener()).build((CacheLoader)new TemplateInfoLoader());
    private AtomicReference<GoogleCacheInstruments> templateCacheInstruments = new AtomicReference();
    private final AtomicReference<GoogleCacheInstruments> directivesCacheInstruments = new AtomicReference();

    public VelocityTemplateCache() {
        this((DirectiveChecker)new DefaultDirectiveChecker());
    }

    public VelocityTemplateCache(DirectiveChecker directiveChecker) {
        this.directiveChecker = directiveChecker;
    }

    public void start() throws Exception {
        this.templateCacheInstruments.set(new GoogleCacheInstruments(this.getClass().getSimpleName()).addCache((Cache)this.cache).install());
        this.directivesCacheInstruments.set(new GoogleCacheInstruments(this.getClass().getSimpleName() + ".directives").install());
    }

    @EventListener
    public void onClearCaches(ClearCacheEvent clearCacheEvent) {
        log.debug("Invalidating all entries in {}", (Object)this);
        this.cache.invalidateAll();
    }

    public boolean isDirectivePresent(String directiveName, Template template) {
        try {
            return ((TemplateInfo)((Object)this.cache.get((Object)template))).isDirectivePresent(directiveName);
        }
        catch (ExecutionException e) {
            log.warn(String.format("Error getting cached TemplateInfo for: %s", template), (Throwable)e);
            return this.directiveChecker.isPresent(directiveName, template);
        }
    }

    final class TemplateInfoRemovalListener
    implements RemovalListener<Template, TemplateInfo> {
        TemplateInfoRemovalListener() {
        }

        public void onRemoval(RemovalNotification<Template, TemplateInfo> removalNotification) {
            TemplateInfo removedTemplateInfo = (TemplateInfo)((Object)removalNotification.getValue());
            if (removedTemplateInfo != null) {
                ((GoogleCacheInstruments)VelocityTemplateCache.this.directivesCacheInstruments.get()).removeCache((Cache)removedTemplateInfo.directivePresentCache);
            }
        }
    }

    private final class TemplateInfoLoader
    extends CacheLoader<Template, TemplateInfo> {
        private TemplateInfoLoader() {
        }

        public TemplateInfo load(Template key) throws Exception {
            return new TemplateInfo(key);
        }
    }

    @ThreadSafe
    final class TemplateInfo
    extends CacheLoader<String, Boolean> {
        private final Template template;
        final LoadingCache<String, Boolean> directivePresentCache;

        public TemplateInfo(Template template) {
            this.template = template;
            this.directivePresentCache = CacheBuilder.newBuilder().maximumSize(4L).build((CacheLoader)this);
            ((GoogleCacheInstruments)VelocityTemplateCache.this.directivesCacheInstruments.get()).addCache((Cache)this.directivePresentCache);
        }

        public boolean isDirectivePresent(String directiveName) {
            try {
                return (Boolean)this.directivePresentCache.get((Object)directiveName);
            }
            catch (ExecutionException e) {
                log.warn(String.format("Error getting cached for (%s,%s)", directiveName, this.template), (Throwable)e);
                return VelocityTemplateCache.this.directiveChecker.isPresent(directiveName, this.template);
            }
        }

        public Boolean load(String key) throws Exception {
            return VelocityTemplateCache.this.directiveChecker.isPresent(key, this.template);
        }
    }
}

