/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bean.export.IllegalXMLCharactersException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.license.LicenseJohnsonEventRaiser;
import com.atlassian.jira.license.MultiLicenseStore;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.startup.JiraStartupChecklist;
import com.atlassian.jira.upgrade.UpgradeManager;
import com.atlassian.jira.upgrade.UpgradeManagerParams;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import java.io.File;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeLauncher
implements JiraLauncher {
    private static final Logger log = LoggerFactory.getLogger(UpgradeLauncher.class);
    private static final String NO_UPGRADE_MESSAGE = "No upgrade is being performed due to detected inconsistencies.";
    private static final String LS = JiraSystemProperties.getInstance().getProperty("line.separator");
    private final JohnsonProvider johnsonProvider;

    public UpgradeLauncher(JohnsonProvider johnsonProvider) {
        this.johnsonProvider = johnsonProvider;
    }

    @Override
    public void start() {
        try {
            ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
            if ("true".equals(applicationProperties.getString("jira.setup"))) {
                UpgradeLauncher.checkIfUpgradeNeeded(ServletContextProvider.getServletContext(), this.johnsonProvider);
            }
        }
        catch (RuntimeException rte) {
            log.error("A RuntimeException occurred during UpgradeLauncher servlet context initialisation - " + rte.getMessage() + ".", (Throwable)rte);
            throw rte;
        }
        catch (Error error) {
            log.error("An Error occurred during UpgradeLauncher servlet context initialisation - " + error.getMessage() + ".", (Throwable)error);
            throw error;
        }
    }

    @Override
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkIfUpgradeNeeded(ServletContext servletContext, JohnsonProvider johnsonProvider) {
        UpgradeLauncher.ensureLicenseNotCorrupted();
        if (JiraStartupChecklist.startupOK()) {
            JohnsonEventContainer eventContainer = johnsonProvider.getContainer();
            if (UpgradeLauncher.checkLicenseIsValid()) {
                Event upgradingEvent = new Event(EventType.get((String)"upgrade"), "JIRA is currently being upgraded", EventLevel.get((String)"warning"));
                eventContainer.addEvent(upgradingEvent);
                try {
                    UpgradeManager manager = (UpgradeManager)ComponentAccessor.getComponentOfType(UpgradeManager.class);
                    File tempDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
                    try {
                        UpgradeManager.Status status = manager.doUpgradeIfNeededAndAllowed(tempDir.getAbsolutePath(), UpgradeManagerParams.builder().build());
                        UpgradeLauncher.addEventsForErrors(eventContainer, status);
                    }
                    catch (IllegalXMLCharactersException ie) {
                        log.error("Illegal XML characters detected while exporting before upgrade.");
                        Event errorEvent = new Event(EventType.get((String)"export-illegal-xml"), "Illegal XML characters in data prevent successful export before the upgrade.", ie.getMessage(), EventLevel.get((String)"error"));
                        eventContainer.addEvent(errorEvent);
                    }
                }
                catch (Exception upgradeException) {
                    log.error("An error occurred whilst trying to upgrade JIRA.", (Throwable)upgradeException);
                    Event errorEvent = new Event(EventType.get((String)"upgrade"), "An error occurred performing JIRA upgrade", upgradeException.getMessage(), EventLevel.get((String)"error"));
                    eventContainer.addEvent(errorEvent);
                }
                finally {
                    eventContainer.removeEvent(upgradingEvent);
                }
            } else {
                log.error(UpgradeLauncher.constructErrorMessage(eventContainer));
            }
        } else {
            log.error("Skipping, JIRA is locked.");
        }
    }

    private static void ensureLicenseNotCorrupted() {
        try {
            UpgradeLauncher.getJiraLicenseService().getLicenses();
        }
        catch (Exception e) {
            log.error(String.format("This instance contains one or more corrupt licenses. All licenses will be removed and licenses will need to be re-entered.", new Object[0]));
            UpgradeLauncher.getLicenseStore().clear();
        }
    }

    private static boolean checkLicenseIsValid() {
        boolean invalid = false;
        JiraLicenseService licenseService = UpgradeLauncher.getJiraLicenseService();
        if (licenseService.isLicenseSet()) {
            LicenseJohnsonEventRaiser licenseJohnsonEventRaiser = UpgradeLauncher.getLicenseJohnsonEventRaiser();
            invalid = licenseJohnsonEventRaiser.checkLicenseIsTooOldForBuild();
        }
        return !invalid;
    }

    private static void addEventsForErrors(JohnsonEventContainer cont, UpgradeManager.Status status) {
        if (cont != null && status != null && !status.successful()) {
            for (String exception : status.getErrors()) {
                Event errorEvent = new Event(EventType.get((String)"upgrade"), "An error occurred performing JIRA upgrade", exception, EventLevel.get((String)"error"));
                cont.addEvent(errorEvent);
            }
        }
    }

    private static String constructErrorMessage(JohnsonEventContainer cont) {
        StringBuilder errMsg = new StringBuilder(NO_UPGRADE_MESSAGE).append(" ");
        for (Object element : cont.getEvents()) {
            Event errEvent = (Event)element;
            errMsg.append(errEvent.getDesc()).append(LS);
        }
        return errMsg.toString();
    }

    private static JiraLicenseService getJiraLicenseService() {
        return (JiraLicenseService)ComponentAccessor.getComponent(JiraLicenseService.class);
    }

    private static MultiLicenseStore getLicenseStore() {
        return (MultiLicenseStore)ComponentAccessor.getComponent(MultiLicenseStore.class);
    }

    private static LicenseJohnsonEventRaiser getLicenseJohnsonEventRaiser() {
        return (LicenseJohnsonEventRaiser)ComponentAccessor.getComponent(LicenseJohnsonEventRaiser.class);
    }
}

