/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.jira.bean.export.IllegalXMLCharactersException;
import com.atlassian.jira.upgrade.UpgradeHistoryItem;
import com.atlassian.jira.upgrade.UpgradeManagerParams;
import com.atlassian.jira.upgrade.UpgradeTask;
import com.atlassian.scheduler.status.RunDetails;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;

public interface UpgradeManager {
    public int getPendingDelayedUpgradeCount();

    @Nonnull
    public Status scheduleDelayedUpgrades(int var1, boolean var2);

    public boolean areDelayedUpgradesRunning();

    public RunDetails getLastUpgradeResult();

    public Status doUpgradeIfNeededAndAllowed(@Nullable String var1, UpgradeManagerParams var2) throws IllegalXMLCharactersException;

    public String getExportFilePath();

    public List<UpgradeHistoryItem> getUpgradeHistory();

    public boolean hasUpgradeTaskRun(Class<? extends UpgradeTask> var1);

    public static class Status {
        public static final Status OK = new Status(Collections.emptyList());
        private final Collection<String> errors;

        public Status(String error) {
            this((Collection<String>)ImmutableList.of((Object)error));
        }

        public Status(Collection<String> errors) {
            this.errors = errors;
        }

        public boolean successful() {
            return CollectionUtils.isEmpty(this.errors);
        }

        public Collection<String> getErrors() {
            return this.errors;
        }
    }
}

