/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.SqlCallback;
import com.atlassian.jira.model.querydsl.QAvatar;
import com.atlassian.jira.model.querydsl.QOSPropertyEntry;
import com.atlassian.jira.model.querydsl.QOSPropertyNumber;
import com.atlassian.jira.model.querydsl.QOSPropertyString;
import com.atlassian.jira.model.querydsl.QProject;
import com.atlassian.jira.upgrade.AbstractDowngradeTask;
import com.atlassian.jira.upgrade.DowngradeException;
import com.atlassian.jira.upgrade.ReindexRequirement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLQuery;
import com.mysema.query.sql.SQLSubQuery;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DowngradeTask_Build70024
extends AbstractDowngradeTask {
    private static final Logger log = LoggerFactory.getLogger(DowngradeTask_Build70024.class);
    private static final int TRUE = 1;
    private static final int NUMBER_TYPE = 3;
    private static final String ISSUE_TYPE_AVATAR = "issuetype";
    private static final String PROJECT_AVATAR = "project";
    private static final String USER_AVATAR = "user";
    private static final String DEFAULT_PROJECT_AVATAR_KEY = "jira.avatar.default.id";
    private static final String DEFAULT_PROJECT_AVATAR_NAME = "rocket.png";
    private static final String USER_ENTITY_NAME = "ApplicationUser";
    private static final String USER_AVATAR_PROPERTY_KEY = "user.avatar.id";
    private static final String PNG_CONTENT_TYPE = "image/png";
    private static final String SVG_CONTENT_TYPE = "image/svg+xml";
    private static final Map<String, String> ISSUE_TYPE_ICONS_TO_RENAME = ImmutableMap.builder().put((Object)"task.svg", (Object)"task.png").put((Object)"subtask.svg", (Object)"subtask.png").put((Object)"story.svg", (Object)"story.png").put((Object)"improvement.svg", (Object)"improvement.png").put((Object)"sales.svg", (Object)"sales.png").put((Object)"design_task.svg", (Object)"health.png").put((Object)"remove_feature.svg", (Object)"remove_feature.png").put((Object)"requirement.svg", (Object)"requirement.png").put((Object)"newfeature.svg", (Object)"newfeature.png").put((Object)"exclamation.svg", (Object)"exclamation.png").put((Object)"documentation.svg", (Object)"documentation.png").put((Object)"defect.svg", (Object)"defect.png").put((Object)"epic.svg", (Object)"epic.png").put((Object)"genericissue.svg", (Object)"genericissue.png").put((Object)"bug.svg", (Object)"bug.png").put((Object)"question.svg", (Object)"undefined.png").put((Object)"development_task.svg", (Object)"development_task.png").put((Object)"feedback.svg", (Object)"feedback.png").put((Object)"request_access.svg", (Object)"request_access.png").build();
    private static final Map<String, String> PROJECT_ICONS_TO_RENAME = ImmutableMap.builder().put((Object)"cloud.svg", (Object)"cloud.png").put((Object)"spanner.svg", (Object)"config.png").put((Object)"cd.svg", (Object)"disc.png").put((Object)"bird.svg", (Object)"eamesbird.png").put((Object)"money.svg", (Object)"finance.png").put((Object)"mouse-hand.svg", (Object)"hand.png").put((Object)"koala.svg", (Object)"kangaroo.png").put((Object)"yeti.svg", (Object)"new_monster.png").put((Object)"power.svg", (Object)"power.png").put((Object)"nature.svg", (Object)"rainbow.png").put((Object)"refresh.svg", (Object)"refresh.png").put((Object)"rocket.svg", (Object)"rocket.png").put((Object)"phone.svg", (Object)"servicedesk.png").put((Object)"settings.svg", (Object)"settings.png").put((Object)"storm.svg", (Object)"storm.png").put((Object)"plane.svg", (Object)"travel.png").build();
    private static final List<String> PROJECT_ICONS_TO_REMOVE = ImmutableList.of((Object)"default.svg", (Object)"code.svg", (Object)"coffee.svg", (Object)"design.svg", (Object)"drill.svg", (Object)"food.svg", (Object)"notes.svg", (Object)"red-flag.svg", (Object)"science.svg", (Object)"spanner.svg", (Object)"support.svg");
    private static final Map<String, String> USER_ICONS_TO_RENAME = ImmutableMap.builder().put((Object)"Avatar-default.svg", (Object)"Avatar-default.png").build();
    private static final List<String> USER_ICONS_TO_REMOVE = ImmutableList.of((Object)"bull.svg", (Object)"cat.svg", (Object)"dog.svg", (Object)"female_1.svg", (Object)"female_2.svg", (Object)"female_3.svg", (Object)"female_4.svg", (Object)"ghost.svg", (Object)"male_1.svg", (Object)"male_2.svg", (Object)"male_3.svg", (Object)"male_4.svg", (Object[])new String[]{"male_5.svg", "male_6.svg", "male_8.svg", "owl.svg", "pirate.svg", "robot.svg", "vampire.svg"});

    @Override
    public void downgrade() throws DowngradeException {
        this.downgradeIssueTypeIcons();
        this.downgradeProjectIcons();
        this.downgradeUserIcons();
    }

    private void downgradeIssueTypeIcons() {
        this.getDbConnectionManager().execute(new SqlCallback(){

            @Override
            public void run(DbConnection connection) {
                connection.setAutoCommit(false);
                QAvatar a = QAvatar.AVATAR;
                for (Map.Entry iconToRenameEntry : ISSUE_TYPE_ICONS_TO_RENAME.entrySet()) {
                    String oldIconName = (String)iconToRenameEntry.getKey();
                    String newIconName = (String)iconToRenameEntry.getValue();
                    connection.update((RelationalPath<?>)a).where((Predicate)a.avatarType.eq((Object)DowngradeTask_Build70024.ISSUE_TYPE_AVATAR).and((Predicate)a.systemAvatar.eq((Object)1)).and((Predicate)a.fileName.eq((Object)oldIconName))).set((Path)a.fileName, (Object)newIconName).set((Path)a.contentType, (Object)DowngradeTask_Build70024.PNG_CONTENT_TYPE).execute();
                }
                connection.commit();
            }
        });
    }

    private void downgradeProjectIcons() {
        this.getDbConnectionManager().execute(new SqlCallback(){

            @Override
            public void run(DbConnection connection) {
                connection.setAutoCommit(false);
                QAvatar a = QAvatar.AVATAR;
                for (Map.Entry projectIconToRenameEntry : PROJECT_ICONS_TO_RENAME.entrySet()) {
                    String oldIconName = (String)projectIconToRenameEntry.getKey();
                    String newIconName = (String)projectIconToRenameEntry.getValue();
                    connection.update((RelationalPath<?>)a).where((Predicate)a.avatarType.eq((Object)DowngradeTask_Build70024.PROJECT_AVATAR).and((Predicate)a.systemAvatar.eq((Object)1)).and((Predicate)a.fileName.eq((Object)oldIconName))).set((Path)a.fileName, (Object)newIconName).set((Path)a.contentType, (Object)DowngradeTask_Build70024.PNG_CONTENT_TYPE).execute();
                }
                QOSPropertyEntry entry = QOSPropertyEntry.O_S_PROPERTY_ENTRY;
                QOSPropertyString property = QOSPropertyString.O_S_PROPERTY_STRING;
                Long defaultProjectAvatarId = DowngradeTask_Build70024.this.obtainDefaultProjectIcon(connection);
                connection.update((RelationalPath<?>)property).where((Predicate)property.id.eq((Expression)((SQLSubQuery)((SQLSubQuery)new SQLSubQuery().from((Expression)entry)).where((Predicate)entry.propertyKey.eq((Object)DowngradeTask_Build70024.DEFAULT_PROJECT_AVATAR_KEY))).unique(entry.id))).set((Path)property.value, (Object)defaultProjectAvatarId.toString()).execute();
                List oldAvatarIds = ((SQLQuery)((SQLQuery)connection.newSqlQuery().from((Expression)a)).where((Predicate)a.avatarType.eq((Object)DowngradeTask_Build70024.PROJECT_AVATAR).and((Predicate)a.systemAvatar.eq((Object)1).and((Predicate)a.fileName.in((Collection)PROJECT_ICONS_TO_REMOVE))))).list(a.id);
                QProject p = QProject.PROJECT;
                if (!oldAvatarIds.isEmpty()) {
                    connection.update((RelationalPath<?>)p).where((Predicate)p.avatar.in((Collection)oldAvatarIds)).set(p.avatar, (Object)defaultProjectAvatarId).execute();
                } else {
                    log.warn("No project icons to downgrade found.");
                }
                connection.delete((RelationalPath<?>)a).where((Predicate)a.fileName.in((Collection)PROJECT_ICONS_TO_REMOVE).and((Predicate)a.systemAvatar.eq((Object)1)).and((Predicate)a.avatarType.eq((Object)DowngradeTask_Build70024.PROJECT_AVATAR).and((Predicate)a.contentType.eq((Object)DowngradeTask_Build70024.SVG_CONTENT_TYPE)))).execute();
                connection.commit();
            }
        });
    }

    private void downgradeUserIcons() {
        this.getDbConnectionManager().execute(new SqlCallback(){

            @Override
            public void run(DbConnection connection) {
                connection.setAutoCommit(false);
                QAvatar a = QAvatar.AVATAR;
                for (Map.Entry userIconToUpdate : USER_ICONS_TO_RENAME.entrySet()) {
                    String oldIconName = (String)userIconToUpdate.getKey();
                    String newIconName = (String)userIconToUpdate.getValue();
                    connection.update((RelationalPath<?>)a).where((Predicate)a.avatarType.eq((Object)DowngradeTask_Build70024.USER_AVATAR).and((Predicate)a.systemAvatar.eq((Object)1)).and((Predicate)a.fileName.eq((Object)oldIconName))).set((Path)a.fileName, (Object)newIconName).set((Path)a.contentType, (Object)DowngradeTask_Build70024.PNG_CONTENT_TYPE).execute();
                }
                QOSPropertyEntry e = QOSPropertyEntry.O_S_PROPERTY_ENTRY;
                QOSPropertyNumber n = QOSPropertyNumber.O_S_PROPERTY_NUMBER;
                connection.delete((RelationalPath<?>)n).where((Predicate)n.id.in((CollectionExpression)((SQLSubQuery)((SQLSubQuery)new SQLSubQuery().from((Expression)e)).where((Predicate)e.entityName.eq((Object)DowngradeTask_Build70024.USER_ENTITY_NAME).and((Predicate)e.propertyKey.eq((Object)DowngradeTask_Build70024.USER_AVATAR_PROPERTY_KEY)).and((Predicate)e.type.eq((Object)3)))).list(e.id)).and((Predicate)n.value.in((CollectionExpression)((SQLSubQuery)((SQLSubQuery)new SQLSubQuery().from((Expression)a)).where((Predicate)a.avatarType.eq((Object)DowngradeTask_Build70024.USER_AVATAR).and((Predicate)a.systemAvatar.eq((Object)1)).and((Predicate)a.fileName.in((Collection)USER_ICONS_TO_REMOVE)))).list(a.id)))).execute();
                connection.delete((RelationalPath<?>)a).where((Predicate)a.fileName.in((Collection)USER_ICONS_TO_REMOVE).and((Predicate)a.systemAvatar.eq((Object)1)).and((Predicate)a.avatarType.eq((Object)DowngradeTask_Build70024.USER_AVATAR).and((Predicate)a.contentType.eq((Object)DowngradeTask_Build70024.SVG_CONTENT_TYPE)))).execute();
                connection.commit();
            }
        });
    }

    private Long obtainDefaultProjectIcon(DbConnection connection) {
        QAvatar a = QAvatar.AVATAR;
        Long defaultProjectAvatarId = this.selectDefaultProjectIcon(connection);
        if (defaultProjectAvatarId == null) {
            connection.insert(a).set((Path)a.fileName, DEFAULT_PROJECT_AVATAR_NAME).set((Path)a.contentType, PNG_CONTENT_TYPE).set((Path)a.avatarType, PROJECT_AVATAR).set((Path)a.systemAvatar, (Object)1).withId().execute();
            return this.selectDefaultProjectIcon(connection);
        }
        return defaultProjectAvatarId;
    }

    @Nullable
    private Long selectDefaultProjectIcon(DbConnection connection) {
        QAvatar a = QAvatar.AVATAR;
        return (Long)((SQLQuery)((SQLQuery)connection.newSqlQuery().from((Expression)a)).where((Predicate)a.avatarType.eq((Object)PROJECT_AVATAR).and((Predicate)a.systemAvatar.eq((Object)1)).and((Predicate)a.fileName.eq((Object)DEFAULT_PROJECT_AVATAR_NAME)))).singleResult(a.id);
    }

    @Override
    public int getBuildNumber() {
        return 70024;
    }

    @Override
    @Nonnull
    public String getShortDescription() {
        return "Downgrade issue type, project and user icons to raster versions.";
    }

    @Override
    @Nonnull
    public ReindexRequirement reindexRequired() {
        return ReindexRequirement.NONE;
    }
}

