/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.profile;

import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.GadgetRequestContextFactory;
import com.atlassian.gadgets.GadgetState;
import com.atlassian.gadgets.view.GadgetViewFactory;
import com.atlassian.gadgets.view.ModuleId;
import com.atlassian.gadgets.view.View;
import com.atlassian.gadgets.view.ViewType;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.profile.UserProfileFragment;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginAccessor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import webwork.action.ActionContext;

public class ActivityUserProfileFragment
implements UserProfileFragment {
    private static final String ACTIVTY_STREAM_GADGET_MODULE_KEY = "com.atlassian.streams.streams-jira-plugin:activitystream-gadget";
    private static final String PREF_IS_CONFIGURED = "isConfigured";
    private static final String GADGET_URI = "rest/gadgets/1.0/g/com.atlassian.streams.streams-jira-plugin/gadgets/activitystream-gadget.xml";
    private static final String PREF_NUMOFENTRIES = "numofentries";
    private static final String NUMOFENTRIES = "10";
    private static final String PREFS_IS_CONFIGURABLE = "isConfigurable";
    private static final String PREF_TITLE_REQUIRED = "titleRequired";
    private static final String PREF_USERNAME = "username";
    private final PluginAccessor pluginAccessor;
    private final GadgetRequestContextFactory gadgetRequestContextFactory;
    private final I18nHelper.BeanFactory i18nFactory;

    public ActivityUserProfileFragment(PluginAccessor pluginAccessor, GadgetRequestContextFactory gadgetRequestContextFactory, I18nHelper.BeanFactory i18nFactory) {
        this.pluginAccessor = pluginAccessor;
        this.gadgetRequestContextFactory = gadgetRequestContextFactory;
        this.i18nFactory = i18nFactory;
    }

    @Override
    public boolean showFragment(ApplicationUser profileUser, ApplicationUser currentUser) {
        GadgetViewFactory viewFactory = (GadgetViewFactory)ComponentAccessor.getOSGiComponentInstanceOfType(GadgetViewFactory.class);
        return viewFactory != null && this.pluginAccessor.isPluginModuleEnabled(ACTIVTY_STREAM_GADGET_MODULE_KEY);
    }

    @Override
    public String getFragmentHtml(ApplicationUser profileUser, ApplicationUser currentUser) {
        GadgetViewFactory viewFactory = (GadgetViewFactory)ComponentAccessor.getOSGiComponentInstanceOfType(GadgetViewFactory.class);
        MapBuilder prefsBuilder = MapBuilder.newBuilder();
        prefsBuilder.add((Object)PREF_IS_CONFIGURED, (Object)Boolean.TRUE.toString());
        prefsBuilder.add((Object)PREFS_IS_CONFIGURABLE, (Object)Boolean.FALSE.toString());
        prefsBuilder.add((Object)PREF_NUMOFENTRIES, (Object)NUMOFENTRIES);
        prefsBuilder.add((Object)PREF_TITLE_REQUIRED, (Object)Boolean.FALSE.toString());
        prefsBuilder.add((Object)PREF_USERNAME, (Object)ActivityUserProfileFragment.escapeArgument(profileUser.getName()));
        GadgetState gadget = GadgetState.gadget((GadgetId)GadgetId.valueOf((String)"1")).specUri(URI.create(GADGET_URI)).userPrefs(prefsBuilder.toMap()).build();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter gadgetWriter = new OutputStreamWriter(baos);
        GadgetRequestContext requestContext = this.gadgetRequestContextFactory.get(ActionContext.getRequest());
        View settings = new View.Builder().viewType(ViewType.DEFAULT).writable(false).build();
        try {
            viewFactory.createGadgetView(gadget, ModuleId.valueOf((long)1L), settings, requestContext).writeTo((Writer)gadgetWriter);
            ((Writer)gadgetWriter).flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        I18nHelper i18n = this.i18nFactory.getInstance(currentUser);
        return "<div class=\"mod-header\"><h3>" + i18n.getText("common.concepts.activity.stream") + "</h3></div><div class=\"mod-content\">" + baos.toString() + "</div>";
    }

    @Override
    public String getId() {
        return "activity-profile-fragment";
    }

    private static String escapeArgument(String argument) {
        return argument.replace("_", "\\_").replace(' ', '_');
    }
}

