/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.system.check;

import com.atlassian.jira.util.system.check.I18nMessage;
import com.atlassian.jira.util.system.check.SystemEnvironmentCheck;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;

public class JRA21845Check
implements SystemEnvironmentCheck {
    public static final String JRA = "JRA21845";

    @Override
    public I18nMessage getWarningMessage() {
        if (this.isWrongLoginCookieKey()) {
            HelpUtil helpUtil = new HelpUtil();
            I18nMessage warning = new I18nMessage(String.format("admin.warning.%s.logincookie.syscheck", JRA));
            warning.setLink(helpUtil.getHelpPath(JRA).getUrl());
            return warning;
        }
        return null;
    }

    private boolean isWrongLoginCookieKey() {
        SecurityConfig securityConfig = SecurityConfigFactory.getInstance();
        String loginCookieKey = securityConfig.getLoginCookieKey();
        return loginCookieKey == null || !loginCookieKey.equals("seraph.rememberme.cookie");
    }
}

