/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.customfields;

import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;

@WebSudoRequired
public class ConfigureCustomField
extends JiraWebActionSupport {
    private Long customFieldId;
    private ManagedConfigurationItem managedConfigurationItem;
    private final FieldConfigSchemeManager schemeManager;
    private final CustomFieldManager customFieldManager;
    private final ManagedConfigurationItemService managedConfigurationItemService;

    public ConfigureCustomField(FieldConfigSchemeManager schemeManager, CustomFieldManager customFieldManager, ManagedConfigurationItemService managedConfigurationItemService) {
        this.schemeManager = schemeManager;
        this.customFieldManager = customFieldManager;
        this.managedConfigurationItemService = managedConfigurationItemService;
    }

    protected String doExecute() throws Exception {
        return "success";
    }

    public List<FieldConfigScheme> getConfigs() {
        if (this.getCustomFieldId() != null) {
            CustomField customField = this.getCustomField();
            return this.schemeManager.getConfigSchemesForField((ConfigurableField)customField);
        }
        return null;
    }

    public CustomField getCustomField() {
        return this.customFieldManager.getCustomFieldObject(this.getCustomFieldId());
    }

    public Long getCustomFieldId() {
        return this.customFieldId;
    }

    public void setCustomFieldId(Long customFieldId) {
        this.customFieldId = customFieldId;
    }

    public boolean isFieldManaged() {
        return this.getManagedConfigurationItem().isManaged();
    }

    public boolean isFieldLocked() {
        return !this.managedConfigurationItemService.doesUserHavePermission(this.getLoggedInUser(), this.getManagedConfigurationItem());
    }

    public String getManagedFieldDescriptionKey() {
        return this.getManagedConfigurationItem().getDescriptionI18nKey();
    }

    public ManagedConfigurationItem getManagedConfigurationItem() {
        if (this.managedConfigurationItem == null) {
            this.managedConfigurationItem = this.managedConfigurationItemService.getManagedCustomField(this.getCustomField());
        }
        return this.managedConfigurationItem;
    }
}

