/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens.enterprise;

import com.atlassian.jira.issue.fields.screen.FieldScreenFactory;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntityImpl;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.Collection;

@WebSudoRequired
public class EditIssueTypeScreenScheme
extends JiraWebActionSupport {
    private final FieldScreenFactory fieldScreenFactory;
    private final FieldScreenSchemeManager fieldScreenSchemeManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private Collection issueTypeScreenSchemes;
    private Long id;
    private String schemeName;
    private String schemeDescription;
    private IssueTypeScreenScheme issueTypeScreenScheme;
    private boolean edited;

    public EditIssueTypeScreenScheme(FieldScreenFactory fieldScreenFactory, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, FieldScreenSchemeManager fieldScreenSchemeManager) {
        this.fieldScreenFactory = fieldScreenFactory;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.fieldScreenSchemeManager = fieldScreenSchemeManager;
    }

    public String doDefault() throws Exception {
        this.validateId();
        if (!this.invalidInput()) {
            this.setSchemeName(this.getIssueTypeScreenScheme().getName());
            this.setSchemeDescription(this.getIssueTypeScreenScheme().getDescription());
        }
        return "input";
    }

    protected void validateId() {
        if (this.getId() == null) {
            this.addErrorMessage(this.getText("admin.errors.id.cannot.be.null"));
        } else if (this.getIssueTypeScreenScheme() == null) {
            this.addErrorMessage(this.getText("admin.errors.fieldlayout.invalid.id2"));
        }
    }

    protected void doValidation() {
        this.validateId();
        if (!this.invalidInput()) {
            this.validateName(true);
        }
    }

    protected void validateName(boolean ignoreSameScheme) {
        if (!TextUtils.stringSet((String)this.getSchemeName())) {
            this.addError("schemeName", this.getText("admin.common.errors.validname"));
        } else {
            for (IssueTypeScreenScheme issueTypeScreenScheme : this.issueTypeScreenSchemeManager.getIssueTypeScreenSchemes()) {
                if (ignoreSameScheme && (!ignoreSameScheme || this.getId().equals(issueTypeScreenScheme.getId())) || !this.getSchemeName().equals(issueTypeScreenScheme.getName())) continue;
                this.addError("schemeName", this.getText("admin.errors.screens.duplicate.screen.scheme.name"));
            }
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.getIssueTypeScreenScheme().setName(this.getSchemeName());
        this.getIssueTypeScreenScheme().setDescription(this.getSchemeDescription());
        this.getIssueTypeScreenScheme().store();
        return this.redirectToView();
    }

    public Collection getIssueTypeScreenSchemes() {
        if (this.issueTypeScreenSchemes == null) {
            this.issueTypeScreenSchemes = this.issueTypeScreenSchemeManager.getIssueTypeScreenSchemes();
        }
        return this.issueTypeScreenSchemes;
    }

    protected String redirectToView() {
        return this.getRedirect("ViewIssueTypeScreenSchemes.jspa");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }

    public String getSchemeDescription() {
        return this.schemeDescription;
    }

    public void setSchemeDescription(String schemeDescription) {
        this.schemeDescription = schemeDescription;
    }

    public IssueTypeScreenScheme getIssueTypeScreenScheme() {
        if (this.issueTypeScreenScheme == null) {
            this.issueTypeScreenScheme = this.issueTypeScreenSchemeManager.getIssueTypeScreenScheme(this.getId());
        }
        return this.issueTypeScreenScheme;
    }

    public String doViewCopyIssueTypeScreenScheme() {
        this.validateId();
        if (!this.invalidInput()) {
            this.setSchemeName(this.getText("common.words.copyof", this.getIssueTypeScreenScheme().getName()));
            this.setSchemeDescription(this.getIssueTypeScreenScheme().getDescription());
            return "input";
        }
        return this.getResult();
    }

    @RequiresXsrfCheck
    public String doCopyIssueTypeScreenScheme() {
        this.validateId();
        if (!this.invalidInput()) {
            this.validateName(false);
            if (!this.invalidInput()) {
                IssueTypeScreenScheme issueTypeScreenScheme = this.fieldScreenFactory.createIssueTypeScreenScheme();
                issueTypeScreenScheme.setName(this.getSchemeName());
                issueTypeScreenScheme.setDescription(this.getSchemeDescription());
                issueTypeScreenScheme.store();
                for (IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity : this.getIssueTypeScreenScheme().getEntities()) {
                    IssueTypeScreenSchemeEntityImpl copyIssueTypeScreenSchemeEntity = new IssueTypeScreenSchemeEntityImpl(this.issueTypeScreenSchemeManager, issueTypeScreenSchemeEntity, this.fieldScreenSchemeManager, this.getConstantsManager());
                    issueTypeScreenScheme.addEntity((IssueTypeScreenSchemeEntity)copyIssueTypeScreenSchemeEntity);
                }
                return this.redirectToView();
            }
        }
        return this.getResult();
    }

    public boolean isEdited() {
        return this.edited;
    }

    public void setEdited(boolean edited) {
        this.edited = edited;
    }
}

