/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.subtasks;

import com.atlassian.jira.config.IssueTypeService;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.issuetypes.DeleteIssueType;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;

@WebSudoRequired
public class DeleteSubTaskIssueType
extends DeleteIssueType {
    private final IssueTypeService issueTypeService;

    public DeleteSubTaskIssueType(IssueTypeService issueTypeService) {
        super(issueTypeService);
        this.issueTypeService = issueTypeService;
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    @Override
    protected String getNiceConstantName() {
        return this.getText("admin.issue.constant.subtask.issuetype.lowercase");
    }

    @Override
    protected String getRedirectPage() {
        return "ManageSubTasks.jspa";
    }

    @Override
    protected Collection<IssueType> getConstants() {
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.issueTypeService.getIssueTypes(this.getLoggedInUser()), (Predicate)new Predicate<IssueType>(){

            public boolean apply(IssueType issueType) {
                return issueType.isSubTask();
            }
        }));
    }
}

