/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.filter;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.filter.FilterSubscriptionService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.issue.subscription.FilterSubscription;
import com.atlassian.jira.issue.subscription.SubscriptionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.filter.AbstractFilterAction;
import com.atlassian.jira.web.action.filter.FilterOperationsAction;
import com.atlassian.jira.web.bean.FilterUtils;
import com.atlassian.jira.web.component.cron.CronEditorBean;
import com.atlassian.jira.web.component.cron.CronEditorWebComponent;
import com.atlassian.jira.web.component.cron.generator.CronExpressionGenerator;
import com.atlassian.jira.web.component.cron.parser.CronExpressionParser;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.opensymphony.util.TextUtils;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import org.ofbiz.core.entity.GenericEntityException;
import webwork.action.ActionContext;

public class EditSubscription
extends AbstractFilterAction
implements FilterOperationsAction {
    private Long subId = null;
    private String groupName;
    private Boolean emailOnEmpty = Boolean.FALSE;
    private Date lastRun;
    private Date nextRun;
    private SubscriptionManager subscriptionManager = ComponentAccessor.getSubscriptionManager();
    private CronEditorBean cronEditorBean;
    private final FilterSubscriptionService filterSubscriptionService;

    public EditSubscription(IssueSearcherManager issueSearcherManager, FilterSubscriptionService filterSubscriptionService, SearchService searchService, SearchSortUtil searchSortUtil) {
        super(issueSearcherManager, searchService, searchSortUtil);
        this.filterSubscriptionService = filterSubscriptionService;
    }

    public String doDefault() throws Exception {
        if (this.subId == null && this.getFilterId() == null) {
            this.addErrorMessage(this.getText("filtersubscription.please.select.a.subscription.or.filter"));
            return "error";
        }
        if (this.subId != null) {
            FilterSubscription subscription = this.subscriptionManager.getFilterSubscription(this.getLoggedInUser(), this.subId);
            if (subscription == null) {
                return "permissionviolation";
            }
            this.groupName = subscription.getGroupName();
            this.emailOnEmpty = subscription.isEmailOnEmpty();
            this.lastRun = subscription.getLastRunTime();
            String cronExpression = this.subscriptionManager.getCronExpressionForSubscription(subscription);
            CronExpressionParser cronExpresionParser = new CronExpressionParser(cronExpression);
            this.cronEditorBean = cronExpresionParser.getCronEditorBean();
            this.nextRun = null;
        }
        if (this.getFilterId() != null && this.getFilter() == null) {
            return "error";
        }
        return super.doDefault();
    }

    public void doValidation() {
        this.cronEditorBean = new CronEditorBean("filter.subscription.prefix", ActionContext.getParameters());
        CronEditorWebComponent component = new CronEditorWebComponent();
        this.addErrorCollection(component.validateInput(this.cronEditorBean, "cron.editor.name"));
        if (!this.hasAnyErrors()) {
            JiraServiceContext serviceContext = this.getJiraServiceContext();
            String cronString = component.getCronExpressionFromInput(this.cronEditorBean);
            this.filterSubscriptionService.validateCronExpression(serviceContext, cronString);
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        String cronExpression = new CronExpressionGenerator().getCronExpressionFromInput(this.cronEditorBean);
        if (this.subId != null) {
            FilterSubscription subscription = this.subscriptionManager.getFilterSubscription(this.getLoggedInUser(), this.subId);
            if (subscription == null) {
                return "permissionviolation";
            }
            this.filterSubscriptionService.updateSubscription(this.getJiraServiceContext(), this.subId, this.getGroupName(), cronExpression, this.emailOnEmpty.booleanValue());
        } else {
            if (this.getFilter() == null) {
                return "securitybreach";
            }
            this.filterSubscriptionService.storeSubscription(this.getJiraServiceContext(), this.getFilterId(), this.getGroupName(), cronExpression, this.getEmailOnEmpty().booleanValue());
        }
        if (this.isInlineDialogMode()) {
            return this.returnComplete(this.getReturnUrl());
        }
        return this.getReturnUrl() == null ? this.getRedirect("ViewSubscriptions.jspa?filterId=" + this.getFilterId()) : this.getRedirect(this.getReturnUrl());
    }

    @RequiresXsrfCheck
    public String doDelete() throws Exception {
        FilterSubscription subscription = this.subscriptionManager.getFilterSubscription(this.getLoggedInUser(), this.subId);
        if (subscription == null) {
            this.addErrorMessage(this.getText("subscriptions.error.delete.subscriptiondoesnotexist"));
            return "error";
        }
        ComponentAccessor.getSubscriptionManager().deleteSubscription(this.subId);
        return this.getRedirect("ViewSubscriptions.jspa?filterId=" + this.getFilterId());
    }

    @RequiresXsrfCheck
    public String doRunNow() throws Exception {
        FilterSubscription subscription = this.subscriptionManager.getFilterSubscription(this.getLoggedInUser(), this.subId);
        if (subscription == null) {
            this.addErrorMessage(this.getText("subscriptions.error.runnow.subscriptiondoesnotexist"));
            return "error";
        }
        ComponentAccessor.getSubscriptionManager().runSubscription(this.getLoggedInUser(), this.subId);
        return this.getRedirect("ViewSubscriptions.jspa?filterId=" + this.getFilterId());
    }

    public boolean hasGroupPermission() throws GenericEntityException {
        return ComponentAccessor.getPermissionManager().hasPermission(24, this.getLoggedInUser());
    }

    public String getSubmitName() throws GenericEntityException {
        if (this.subId == null) {
            return this.getText("filtersubscription.subscribe");
        }
        return this.getText("common.forms.update");
    }

    public String getCancelStr() throws GenericEntityException {
        if (this.getReturnUrl() != null) {
            return this.getReturnUrl();
        }
        if (this.subId == null) {
            return "ManageFilters.jspa";
        }
        return "ViewSubscriptions.jspa?filterId=" + this.getFilterId();
    }

    public String getSubId() {
        if (this.subId == null) {
            return null;
        }
        return this.subId.toString();
    }

    public void setSubId(String subId) {
        if (TextUtils.stringSet((String)subId)) {
            this.subId = new Long(subId);
        }
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Boolean getEmailOnEmpty() {
        return this.emailOnEmpty;
    }

    public void setEmailOnEmpty(Boolean emailOnEmpty) {
        this.emailOnEmpty = emailOnEmpty;
    }

    public String getLastRun() {
        if (this.lastRun == null) {
            return null;
        }
        return String.valueOf(this.lastRun.getTime());
    }

    public void setLastRun(String lastRun) {
        if (TextUtils.stringSet((String)lastRun)) {
            this.lastRun = new Timestamp(Long.parseLong(lastRun));
        }
    }

    public String getNextRun() {
        if (this.nextRun == null) {
            return null;
        }
        return String.valueOf(this.nextRun.getTime());
    }

    public void setNextRun(String nextRun) {
        if (TextUtils.stringSet((String)nextRun)) {
            this.nextRun = new Timestamp(Long.parseLong(nextRun));
        }
    }

    public String getLastRunStr() {
        if (this.lastRun == null) {
            return null;
        }
        return ((OutlookDateManager)ComponentAccessor.getComponent(OutlookDateManager.class)).getOutlookDate(this.getLocale()).formatDMYHMS(this.lastRun);
    }

    public String getNextRunStr() {
        if (this.nextRun == null) {
            return null;
        }
        return ((OutlookDateManager)ComponentAccessor.getComponent(OutlookDateManager.class)).getOutlookDate(this.getLocale()).formatDMYHMS(this.nextRun);
    }

    public Collection getGroups() {
        return FilterUtils.getGroups(this.getLoggedInUser());
    }

    public CronEditorBean getCronEditorBean() {
        if (this.cronEditorBean == null) {
            this.cronEditorBean = new CronExpressionParser().getCronEditorBean();
        }
        return this.cronEditorBean;
    }

    public String getHelpLink() {
        return "issue_filters_subscribing";
    }
}

