/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.filter;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.renderer.ProjectDescriptionRenderer;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.filter.FilterLinkRenderer;
import com.atlassian.jira.web.action.filter.FilterViewHelper;
import com.atlassian.jira.web.action.filter.FilterViewTabs;
import com.atlassian.jira.web.action.filter.ProjectFetcher;
import com.atlassian.jira.web.action.util.SearchRequestDisplayBean;
import com.atlassian.jira.web.action.util.sharing.SharedEntitySearchAction;
import com.atlassian.jira.web.action.util.sharing.SharedEntitySearchViewHelper;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import webwork.action.ActionContext;

public class FilterPickerPopup
extends JiraWebActionSupport
implements ProjectFetcher,
SharedEntitySearchAction {
    private static final FilterLinkRenderer FILTER_PICKER_CALLBACK_LINK_RENDERER = new FilterLinkRenderer(){

        @Override
        public String render(Long id, String name) {
            return "<a href=\"#\" id=\"filterlink_" + id + "\" onclick=\"submitFilter('" + id + "', this);\"'>" + TextUtils.htmlEncode((String)name) + "</a>";
        }
    };
    private static final FilterLinkRenderer PROJECT_PICKER_CALLBACK_LINK_RENDERER = new FilterLinkRenderer(){

        @Override
        public String render(Long id, String name) {
            return "<a href=\"#\" id=\"filterlink_" + id + "\" onclick=\"submitProject('" + id + "', this);\"'>" + TextUtils.htmlEncode((String)name) + "</a>";
        }
    };
    private final SearchRequestService searchRequestService;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final SearchRequestDisplayBean.Factory beanFactory;
    private final FilterPickerPopupViewHelper filterHelper;
    private final ProjectDescriptionRenderer projectDescriptionRenderer;
    private String filterView = null;
    private List<SearchRequestDisplayBean> filters = null;
    private SharedEntitySearchViewHelper.SearchResult searchResults = null;
    private FilterViewTabs validTabs = null;

    public FilterPickerPopup(SearchRequestService searchRequestService, ShareTypeFactory shareTypeFactory, PermissionManager permissionManager, JiraAuthenticationContext authCtx, ProjectManager projectManager, SearchRequestDisplayBean.Factory beanFactory, ProjectDescriptionRenderer projectDescriptionRenderer) {
        this.searchRequestService = searchRequestService;
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
        this.beanFactory = beanFactory;
        this.projectDescriptionRenderer = projectDescriptionRenderer;
        this.filterHelper = new FilterPickerPopupViewHelper(shareTypeFactory, authCtx, ActionContext.getRequest().getContextPath(), "FilterPickerPopup.jspa", searchRequestService);
    }

    @Override
    public String getSearchName() {
        return this.filterHelper.getSearchName();
    }

    @Override
    public void setSearchName(String searchName) {
        this.filterHelper.setSearchName(searchName);
    }

    @Override
    public String getSearchOwnerUserName() {
        return this.filterHelper.getSearchOwnerUserName();
    }

    @Override
    public void setSearchOwnerUserName(String searchOwnerUserName) {
        this.filterHelper.setSearchOwnerUserName(searchOwnerUserName);
    }

    @Override
    public String getSearchShareType() {
        return this.filterHelper.getSearchShareType();
    }

    @Override
    public void setSearchShareType(String searchShareType) {
        this.filterHelper.setSearchShareType(searchShareType);
    }

    @Override
    public void setGroupShare(String groupShare) {
        this.filterHelper.setGroupShare(groupShare);
    }

    @Override
    public String getGroupShare() {
        return this.filterHelper.getGroupShare();
    }

    @Override
    public Long getPagingOffset() {
        return this.filterHelper.getPagingOffset();
    }

    @Override
    public void setProjectShare(String projectShare) {
        this.filterHelper.setProjectShare(projectShare);
    }

    @Override
    public String getProjectShare() {
        return this.filterHelper.getProjectShare();
    }

    @Override
    public void setRoleShare(String roleShare) {
        this.filterHelper.setRoleShare(roleShare);
    }

    @Override
    public String getRoleShare() {
        return this.filterHelper.getRoleShare();
    }

    @Override
    public void setPagingOffset(Long pagingOffset) {
        this.filterHelper.setPagingOffset(pagingOffset);
    }

    @Override
    public String getSortColumn() {
        return this.filterHelper.getSortColumn();
    }

    @Override
    public void setSortColumn(String sortColumn) {
        this.filterHelper.setSortColumn(sortColumn);
    }

    @Override
    public boolean isSortAscending() {
        return this.filterHelper.isSortAscending();
    }

    @Override
    public void setSortAscending(boolean sortAscending) {
        this.filterHelper.setSortAscending(sortAscending);
    }

    public String getFilterView() {
        return this.filterView;
    }

    public void setFilterView(String filterView) {
        this.filterView = filterView;
    }

    public boolean isShowFilters() {
        return this.filterHelper.isShowFilters();
    }

    public void setShowFilters(boolean showFilters) {
        this.filterHelper.setShowFilters(showFilters);
    }

    public boolean isShowProjects() {
        return this.filterHelper.isShowProjects();
    }

    public void setShowProjects(boolean showProjects) {
        this.filterHelper.setShowProjects(showProjects);
    }

    public String getField() {
        return this.filterHelper.getField();
    }

    public void setField(String field) {
        this.filterHelper.setField(field);
    }

    public List getFilters() {
        return this.filters;
    }

    public boolean isSearchRequested() {
        return ActionContext.getParameters().get("Search") != null;
    }

    public String getNextUrl() {
        return this.searchResults != null ? this.searchResults.getNextUrl() : null;
    }

    public String getPreviousUrl() {
        return this.searchResults != null ? this.searchResults.getPreviousUrl() : null;
    }

    public int getStartPosition() {
        return this.searchResults != null ? this.searchResults.getStartResultPosition() : -1;
    }

    public int getEndPosition() {
        return this.searchResults != null ? this.searchResults.getEndResultPosition() : -1;
    }

    public int getTotalResultCount() {
        return this.searchResults != null ? this.searchResults.getTotalResultCount() : -1;
    }

    public FilterPickerPopupViewHelper getFiltersViewHelper() {
        return this.filterHelper;
    }

    public String getSearchEmptyMessageKey() {
        if (this.isSearchRequested() && this.filters != null) {
            return "filters.no.search.results";
        }
        return "common.sharing.searching.no.search.performed";
    }

    public boolean isTabShowing(String tab) {
        return this.getTabs().isValid(tab);
    }

    public FilterLinkRenderer getFilterLinkRenderer() {
        if (this.isShowProjects()) {
            if (this.isShowFilters()) {
                return new ProjectLinkRenderer(FilterViewTabs.PROJECT.nameEquals(this.filterView) ? "project" : "filter");
            }
            return PROJECT_PICKER_CALLBACK_LINK_RENDERER;
        }
        return FILTER_PICKER_CALLBACK_LINK_RENDERER;
    }

    public boolean showCategories() {
        return this.someCategoriesExist();
    }

    private boolean someCategoriesExist() {
        return !this.getCategories().isEmpty();
    }

    public Collection<ProjectCategory> getCategories() {
        return this.projectManager.getAllProjectCategories();
    }

    protected String doExecute() {
        boolean filterViewSet;
        FilterViewTabs.Tab currentTab = this.getTabs().getTabSafely(this.filterView);
        boolean bl = filterViewSet = this.filterView != null;
        if (currentTab != null) {
            this.filterView = currentTab.getName();
            if (FilterViewTabs.FAVOURITES == currentTab) {
                boolean hasFavourites = this.executeFavouriteView();
                if (!hasFavourites && !filterViewSet) {
                    this.filterView = FilterViewTabs.SEARCH.getName();
                    this.executeSearchView();
                }
            } else if (FilterViewTabs.SEARCH == currentTab) {
                this.executeSearchView();
            } else if (FilterViewTabs.POPULAR == currentTab) {
                this.executePopularView();
            } else if (FilterViewTabs.FAVOURITES == currentTab) {
                this.executeFavouriteView();
            } else if (FilterViewTabs.PROJECT != currentTab) {
                this.filterView = null;
            }
        } else {
            this.filterView = null;
        }
        return "input";
    }

    private void executeSearchView() {
        boolean searchPerformed = this.isSearchRequested();
        if (searchPerformed) {
            JiraServiceContext ctx = this.getJiraServiceContext();
            this.searchResults = this.filterHelper.search(ctx);
            if (this.searchResults != null && !ctx.getErrorCollection().hasAnyErrors()) {
                this.filters = this.beanFactory.createDisplayBeans(this.searchResults.getResults());
            }
        }
    }

    private void executePopularView() {
        JiraServiceContext serviceContext = this.getJiraServiceContext();
        List<SearchRequest> results = this.filterHelper.getPopularFilters(serviceContext);
        if (results != null && !serviceContext.getErrorCollection().hasAnyErrors()) {
            this.filters = this.beanFactory.createDisplayBeans(results);
        }
    }

    private boolean executeFavouriteView() {
        Collection favouriteFilters = this.searchRequestService.getFavouriteFilters(this.getLoggedInUser());
        if (!favouriteFilters.isEmpty()) {
            this.filters = this.beanFactory.createDisplayBeans(favouriteFilters);
            return true;
        }
        return false;
    }

    @Override
    public Collection<Project> getProjectsInCategory(ProjectCategory projectCategory) {
        Collection projects = this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, this.getJiraServiceContext().getLoggedInApplicationUser(), projectCategory);
        if (projects == null) {
            return Collections.emptyList();
        }
        return projects;
    }

    @Override
    public Collection<Project> getProjectsInNoCategory() {
        return this.getProjectsInCategory(null);
    }

    @Override
    public boolean projectsExist() {
        return !this.projectManager.getProjectObjects().isEmpty();
    }

    public String getRenderedProjectDescription(Project project) {
        return this.projectDescriptionRenderer.getViewHtml(project.getDescription());
    }

    private FilterViewTabs getTabs() {
        if (this.validTabs == null) {
            FilterViewTabs.Tab defaultTab;
            List<FilterViewTabs.Tab> tabs;
            if (!this.isShowFilters()) {
                tabs = new ArrayList<FilterViewTabs.Tab>();
                defaultTab = null;
            } else if (this.getLoggedInUser() == null) {
                tabs = CollectionBuilder.newBuilder((Object[])new FilterViewTabs.Tab[]{FilterViewTabs.POPULAR, FilterViewTabs.SEARCH}).asMutableList();
                defaultTab = FilterViewTabs.POPULAR;
            } else {
                tabs = CollectionBuilder.newBuilder((Object[])new FilterViewTabs.Tab[]{FilterViewTabs.FAVOURITES, FilterViewTabs.POPULAR, FilterViewTabs.SEARCH}).asMutableList();
                defaultTab = FilterViewTabs.FAVOURITES;
            }
            if (this.isShowProjects()) {
                tabs.add(FilterViewTabs.PROJECT);
                if (defaultTab == null) {
                    defaultTab = FilterViewTabs.PROJECT;
                }
            }
            this.validTabs = new FilterViewTabs(tabs, defaultTab);
        }
        return this.validTabs;
    }

    private static class ProjectLinkRenderer
    implements FilterLinkRenderer {
        private final String outputField;

        public ProjectLinkRenderer(String outputField) {
            this.outputField = outputField;
        }

        @Override
        public String render(Long id, String name) {
            StringBuilder link = new StringBuilder();
            return link.append("<a href=\"#\" id=\"filterlink_").append(id).append("\" onclick=\"submitFilterOrProject('").append(id).append("', this, '").append(this.outputField).append("');\"'>").append(TextUtils.htmlEncode((String)name)).append("</a>").toString();
        }
    }

    private static class FilterPickerPopupViewHelper
    extends FilterViewHelper {
        private boolean showFilters = true;
        private boolean showProjects = false;
        private String field;

        public FilterPickerPopupViewHelper(ShareTypeFactory shareTypeFactory, JiraAuthenticationContext authCtx, String applicationContext, String actionUrlPrefix, SearchRequestService searchRequestService) {
            super(shareTypeFactory, authCtx, applicationContext, actionUrlPrefix, searchRequestService);
        }

        public boolean isShowFilters() {
            return this.showFilters;
        }

        public void setShowFilters(boolean showFilters) {
            this.showFilters = showFilters;
        }

        public boolean isShowProjects() {
            return this.showProjects;
        }

        public void setShowProjects(boolean showProjects) {
            this.showProjects = showProjects;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        @Override
        protected StringBuffer createBasicUrlSearchParams() {
            StringBuffer searchParams = super.createBasicUrlSearchParams();
            this.addParameter(searchParams, "field", this.field);
            if (this.showProjects) {
                this.addParameter(searchParams, "showProjects", this.showProjects);
            }
            return searchParams;
        }
    }
}

