/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.user.CreateUserApplicationHelper;
import com.atlassian.jira.bc.user.UserApplicationHelper;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.plugin.user.WebErrorMessage;
import com.atlassian.jira.servlet.JiraCaptchaService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.ActionViewDataMappings;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.octo.captcha.service.CaptchaServiceException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import webwork.action.ActionContext;

public class Signup
extends JiraWebActionSupport {
    private String fullname;
    private String username;
    private String email;
    private String password;
    private String captcha;
    private final ApplicationProperties applicationProperties;
    private final UserService userService;
    private final ExternalLinkUtil externalLinkUtil;
    private final JiraCaptchaService jiraCaptchaService;
    private final CreateUserApplicationHelper applicationHelper;
    private final ApplicationRoleManager roleManager;
    private final UserUtil userUtil;
    private final PageBuilderService pageBuilderService;
    private UserService.CreateUserValidationResult result;
    private List<WebErrorMessage> passwordErrors;

    public Signup(ApplicationProperties applicationProperties, UserService userService, JiraCaptchaService jiraCaptchaService, ExternalLinkUtil externalLinkUtil, CreateUserApplicationHelper applicationHelper, ApplicationRoleManager roleManager, UserUtil userUtil, PageBuilderService pageBuilderService) {
        this.applicationProperties = applicationProperties;
        this.userService = userService;
        this.jiraCaptchaService = jiraCaptchaService;
        this.externalLinkUtil = externalLinkUtil;
        this.applicationHelper = applicationHelper;
        this.roleManager = roleManager;
        this.userUtil = userUtil;
        this.pageBuilderService = pageBuilderService;
    }

    public String doDefault() throws Exception {
        this.requireResources();
        if (!JiraUtils.isPublicMode()) {
            return "modebreach";
        }
        if (this.getLoggedInUser() != null) {
            return "alreadyloggedin";
        }
        if (!this.validateSeats()) {
            return "limitexceeded";
        }
        if (!this.validateApplicationAccess()) {
            return "appaccesserror";
        }
        return super.doDefault();
    }

    protected void doValidation() {
        if (!JiraUtils.isPublicMode()) {
            return;
        }
        if (this.getLoggedInUser() != null) {
            return;
        }
        if (!this.validateSeats()) {
            return;
        }
        if (!this.validateApplicationAccess()) {
            return;
        }
        this.validateCaptcha();
        UserService.CreateUserRequest createUserRequest = UserService.CreateUserRequest.withUserDetails((ApplicationUser)this.getLoggedInUser(), (String)this.getUsername(), (String)this.getPassword(), (String)this.getEmail(), (String)this.getFullname()).passwordRequired().performPermissionCheck(false).sendUserSignupEvent();
        this.result = this.userService.validateCreateUser(createUserRequest);
        if (!this.result.isValid()) {
            this.addErrorCollection(this.result.getErrorCollection());
        }
        this.passwordErrors = this.result.getPasswordErrors();
    }

    protected String doExecute() throws Exception {
        this.requireResources();
        if (!JiraUtils.isPublicMode()) {
            return "modebreach";
        }
        if (this.getLoggedInUser() != null) {
            return "alreadyloggedin";
        }
        if (!this.validateSeats()) {
            return "limitexceeded";
        }
        if (!this.validateApplicationAccess()) {
            return "appaccesserror";
        }
        try {
            ApplicationUser user = this.userService.createUser(this.result);
            if (user == null) {
                this.addErrorMessage(this.getText("signup.error.duplicateuser"));
            }
        }
        catch (CreateException e) {
            this.log.error((Object)"Error creating user from public sign up", (Throwable)e);
            return "systemerror";
        }
        return this.getResult();
    }

    public ExternalLinkUtil getExternalLinkUtils() {
        return this.externalLinkUtil;
    }

    private void validateCaptcha() {
        if (!this.applicationProperties.getOption("jira.option.captcha.on.signup")) {
            return;
        }
        HttpSession session = ActionContext.getRequest().getSession(false);
        if (session == null) {
            this.addErrorMessage(this.getText("session.timeout.message.title"));
            return;
        }
        String captchaId = session.getId();
        Boolean isResponseCorrect = null;
        try {
            isResponseCorrect = this.jiraCaptchaService.getImageCaptchaService().validateResponseForID(captchaId, (Object)this.captcha);
        }
        catch (CaptchaServiceException e) {
            this.addErrorMessage(this.getText("session.timeout.message.title"));
        }
        if (isResponseCorrect != null && !isResponseCorrect.booleanValue()) {
            this.addError("captcha", this.getText("signup.error.captcha.incorrect"));
        }
    }

    private boolean validateApplicationAccess() {
        if (this.roleManager.rolesEnabled()) {
            return this.applicationHelper.validateDefaultApplications(EnumSet.allOf(UserApplicationHelper.ValidationScope.class), Optional.empty()).isEmpty();
        }
        return true;
    }

    private boolean validateSeats() {
        if (this.roleManager.rolesEnabled()) {
            return this.applicationHelper.validateDefaultApplications(EnumSet.of(UserApplicationHelper.ValidationScope.SEATS), Optional.empty()).isEmpty();
        }
        return this.userUtil.canActivateNumberOfUsers(1);
    }

    private void requireResources() {
        this.pageBuilderService.assembler().resources().requireWebResource("jira.webresources:signup");
    }

    @ActionViewData(value="alreadyloggedin")
    public Map<String, Object> getAlreadyLoggedInData() {
        return ImmutableMap.of((Object)"xsrfToken", (Object)StringUtils.defaultIfBlank((String)this.getXsrfToken(), (String)""));
    }

    @ActionViewData(value="success")
    public Map<String, Object> getSuccessSoyData() {
        return ImmutableMap.of((Object)"newsHref", (Object)StringUtils.defaultIfBlank((String)this.getExternalLinkUtils().getProperty("external.link.atlassian.news"), (String)""));
    }

    @ActionViewDataMappings(value={"appaccesserror", "limitexceeded", "systemerror", "modebreach"})
    public Map<String, Object> getSoyData() {
        return ImmutableMap.of((Object)"contactLink", (Object)this.getJiraContactHelper().getAdministratorContactLink(this.getHttpRequest().getContextPath()), (Object)"isContactFormEnabled", (Object)this.getJiraContactHelper().isAdministratorContactFormEnabled(), (Object)"showUpfront", (Object)this.isShowUpfront());
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getUsername() {
        if (this.username != null) {
            return this.username.trim();
        }
        return null;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<String> getPasswordError() {
        if (this.getErrors().containsKey("password")) {
            return ImmutableList.of(this.getErrors().get("password"));
        }
        return ImmutableList.of();
    }

    public List<WebErrorMessage> getPasswordErrors() {
        return this.passwordErrors;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setCaptcha(String captcha) {
        this.captcha = captcha;
    }

    public boolean isShowUpfront() {
        return "GET".equalsIgnoreCase(this.getHttpRequest().getMethod());
    }
}

