/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.mau;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.event.mau.MauEventService;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMauRequestTaggingFilter
extends AbstractHttpFilter {
    private ComponentReference<MauEventService> mauEventService = ComponentAccessor.getComponentReference(MauEventService.class);
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMauRequestTaggingFilter.class);

    protected final void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            Optional<MauEventService> mauEventService = this.getMauEventService();
            if (mauEventService.isPresent()) {
                this.tagRequest(mauEventService.get(), request);
            }
        }
        catch (Exception e) {
            LOG.error("Exception thrown in a MauRequestTaggingFitler", (Throwable)e);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public abstract void tagRequest(MauEventService var1, HttpServletRequest var2);

    @VisibleForTesting
    Optional<MauEventService> getMauEventService() {
        return Optional.ofNullable(this.mauEventService.get());
    }
}

