/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.tags;

import com.atlassian.jira.component.ComponentAccessor;
import com.opensymphony.module.sitemesh.taglib.page.ApplyDecoratorTag;
import javax.servlet.jsp.JspException;

public class JiraApplyDecoratorTag
extends ApplyDecoratorTag {
    private static final String COMPUTED_ID = "jira.sitemesh.decorator.computed.id";
    private static final String CURRENT_ID = "jira.sitemesh.decorator.current.id";
    private String previousId = null;
    private String previousComputedId = null;

    public void setId(String id) {
        this.id = id;
        super.setId(id);
    }

    public int doStartTag() {
        try {
            this.setEncoding(ComponentAccessor.getApplicationProperties().getEncoding());
        }
        catch (Exception e) {
            this.setEncoding("UTF-8");
        }
        this.push();
        return super.doStartTag();
    }

    public int doEndTag() throws JspException {
        int rc = super.doEndTag();
        this.pop();
        return rc;
    }

    private void push() {
        this.previousId = (String)this.pageContext.getRequest().getAttribute(CURRENT_ID);
        this.previousComputedId = (String)this.pageContext.getRequest().getAttribute(COMPUTED_ID);
        this.pageContext.getRequest().setAttribute(CURRENT_ID, (Object)this.id);
        this.pageContext.getRequest().setAttribute(COMPUTED_ID, this.computeId(this.previousComputedId));
    }

    private void pop() {
        this.pageContext.getRequest().setAttribute(CURRENT_ID, (Object)this.previousId);
        this.pageContext.getRequest().setAttribute(COMPUTED_ID, (Object)this.previousComputedId);
    }

    private Object computeId(String previousId) {
        StringBuilder sb = new StringBuilder();
        if (previousId != null && previousId.length() > 0) {
            sb.append(previousId);
        }
        if (this.id != null && this.id.length() > 0) {
            sb.append(this.id).append("-");
        }
        return sb.toString();
    }
}

