/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.web.util.AuthorizationSupport;

public class DefaultAuthorizationSupport
implements AuthorizationSupport {
    private final GlobalPermissionManager globalPermissionManager;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public DefaultAuthorizationSupport(GlobalPermissionManager globalPermissionManager, PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.globalPermissionManager = globalPermissionManager;
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public boolean hasPermission(int permissionsId) {
        return this.permissionManager.hasPermission(permissionsId, this.jiraAuthenticationContext.getLoggedInUser());
    }

    public boolean hasGlobalPermission(GlobalPermissionKey globalPermissionKey) {
        return this.globalPermissionManager.hasPermission(globalPermissionKey, this.jiraAuthenticationContext.getLoggedInUser());
    }

    public boolean hasGlobalPermission(String permissionKey) {
        return this.hasGlobalPermission(GlobalPermissionKey.of((String)permissionKey));
    }

    public boolean hasIssuePermission(String permissionKey, Issue issue) {
        return this.permissionManager.hasPermission(new ProjectPermissionKey(permissionKey), issue, this.jiraAuthenticationContext.getLoggedInUser());
    }

    public boolean hasIssuePermission(int permissionsId, Issue issue) {
        return this.permissionManager.hasPermission(permissionsId, issue, this.jiraAuthenticationContext.getLoggedInUser());
    }

    public boolean hasIssuePermission(ProjectPermissionKey projectPermissionKey, Issue issue) {
        return this.permissionManager.hasPermission(projectPermissionKey, issue, this.jiraAuthenticationContext.getLoggedInUser());
    }

    public boolean hasProjectPermission(int permissionsId, Project project) {
        return this.permissionManager.hasPermission(new ProjectPermissionKey(permissionsId), project, this.jiraAuthenticationContext.getLoggedInUser());
    }

    public boolean hasProjectPermission(ProjectPermissionKey projectPermissionKey, Project project) {
        return this.permissionManager.hasPermission(projectPermissionKey, project, this.jiraAuthenticationContext.getLoggedInUser());
    }
}

