/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webwork.parameters;

import com.atlassian.jira.webwork.parameters.AbstractParameterConverter;
import com.atlassian.jira.webwork.parameters.BooleanArrayConverter;
import com.atlassian.jira.webwork.parameters.BooleanConverter;
import com.atlassian.jira.webwork.parameters.ByteArrayConverter;
import com.atlassian.jira.webwork.parameters.ByteConverter;
import com.atlassian.jira.webwork.parameters.CharacterArrayConverter;
import com.atlassian.jira.webwork.parameters.CharacterConverter;
import com.atlassian.jira.webwork.parameters.DoubleArrayConverter;
import com.atlassian.jira.webwork.parameters.DoubleConverter;
import com.atlassian.jira.webwork.parameters.FloatArrayConverter;
import com.atlassian.jira.webwork.parameters.FloatConverter;
import com.atlassian.jira.webwork.parameters.IntegerArrayConverter;
import com.atlassian.jira.webwork.parameters.IntegerConverter;
import com.atlassian.jira.webwork.parameters.LongArrayConverter;
import com.atlassian.jira.webwork.parameters.LongConverter;
import com.atlassian.jira.webwork.parameters.ParameterConverter;
import com.atlassian.jira.webwork.parameters.ShortArrayConverter;
import com.atlassian.jira.webwork.parameters.ShortConverter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class KnownParameterConverters {
    private static final Map<Class, ParameterConverter> PROPERTY_CONVERTERS;

    public static ParameterConverter getConverter(Class parameterType) {
        return PROPERTY_CONVERTERS.get(parameterType);
    }

    static {
        HashMap<Class<Object>, AbstractParameterConverter> map = new HashMap<Class<Object>, AbstractParameterConverter>();
        map.put(Boolean[].class, new BooleanArrayConverter());
        map.put(boolean[].class, new BooleanArrayConverter());
        map.put(Boolean.class, new BooleanConverter());
        map.put(Boolean.TYPE, new BooleanConverter());
        map.put(Byte[].class, new ByteArrayConverter());
        map.put(byte[].class, new ByteArrayConverter());
        map.put(Byte.class, new ByteConverter());
        map.put(Byte.TYPE, new ByteConverter());
        map.put(Character[].class, new CharacterArrayConverter());
        map.put(char[].class, new CharacterArrayConverter());
        map.put(Character.class, new CharacterConverter());
        map.put(Character.TYPE, new CharacterConverter());
        map.put(Double[].class, new DoubleArrayConverter());
        map.put(double[].class, new DoubleArrayConverter());
        map.put(Double.class, new DoubleConverter());
        map.put(Double.TYPE, new DoubleConverter());
        map.put(Float[].class, new FloatArrayConverter());
        map.put(float[].class, new FloatArrayConverter());
        map.put(Float.class, new FloatConverter());
        map.put(Float.TYPE, new FloatConverter());
        map.put(Integer[].class, new IntegerArrayConverter());
        map.put(int[].class, new IntegerArrayConverter());
        map.put(Integer.class, new IntegerConverter());
        map.put(Integer.TYPE, new IntegerConverter());
        map.put(Long[].class, new LongArrayConverter());
        map.put(long[].class, new LongArrayConverter());
        map.put(Long.class, new LongConverter());
        map.put(Long.TYPE, new LongConverter());
        map.put(Short[].class, new ShortArrayConverter());
        map.put(short[].class, new ShortArrayConverter());
        map.put(Short.class, new ShortConverter());
        map.put(Short.TYPE, new ShortConverter());
        PROPERTY_CONVERTERS = Collections.unmodifiableMap(map);
    }
}

