/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.workflow.WorkflowScheme;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;

abstract class WorkflowSchemeBuilderTemplate<T extends WorkflowScheme.Builder<T>>
implements WorkflowScheme.Builder<T> {
    private final Long id;
    private Map<String, String> mappings;

    WorkflowSchemeBuilderTemplate(Long id, Map<String, String> mappings) {
        this.id = id;
        this.mappings = Maps.newHashMap(mappings);
    }

    WorkflowSchemeBuilderTemplate() {
        this.id = null;
        this.mappings = Maps.newHashMap();
    }

    WorkflowSchemeBuilderTemplate(WorkflowScheme scheme) {
        this.id = scheme.getId();
        this.mappings = Maps.newHashMap((Map)scheme.getMappings());
    }

    @Nonnull
    public T setDefaultWorkflow(@Nonnull String workflowName) {
        this.mappings.put(null, workflowName);
        return this.builder();
    }

    @Nonnull
    public T setMapping(@Nonnull String issueTypeId, @Nonnull String workflowName) {
        this.mappings.put(issueTypeId, workflowName);
        return this.builder();
    }

    @Nonnull
    public T setMappings(@Nonnull Map<String, String> mappings) {
        this.mappings = Maps.newHashMap(mappings);
        return this.builder();
    }

    @Nonnull
    public T removeMapping(@Nonnull String issueTypeId) {
        this.mappings.remove(issueTypeId);
        return this.builder();
    }

    @Nonnull
    public T removeDefault() {
        this.mappings.remove(null);
        return this.builder();
    }

    @Nonnull
    public T clearMappings() {
        this.mappings.clear();
        return this.builder();
    }

    @Nonnull
    public T removeWorkflow(@Nonnull String workflowName) {
        Iterator<String> iterator = this.mappings.values().iterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            if (!workflowName.equals(s)) continue;
            iterator.remove();
        }
        return this.builder();
    }

    public String getDefaultWorkflow() {
        return this.mappings.get(null);
    }

    public String getMapping(@Nonnull String issueTypeId) {
        return this.mappings.get(issueTypeId);
    }

    public Long getId() {
        return this.id;
    }

    public Map<String, String> getMappings() {
        return this.mappings;
    }

    abstract T builder();
}

