/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.function.issue;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.WorkflowStore;
import java.sql.Timestamp;
import java.util.Map;

public class IssueCreateFunction
implements FunctionProvider {
    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        try {
            FieldManager fieldManager = ComponentAccessor.getFieldManager();
            MutableIssue issue = (MutableIssue)transientVars.get("issue");
            Timestamp now = new Timestamp(System.currentTimeMillis());
            if (issue.getCreated() == null) {
                issue.setCreated(now);
            }
            if (issue.getUpdated() == null) {
                issue.setUpdated(now);
            }
            long incCount = ComponentAccessor.getProjectManager().getNextId(issue.getProjectObject());
            issue.setKey(issue.getProjectObject().getKey() + "-" + incCount);
            if (issue.getVotes() == null) {
                issue.setVotes(Long.valueOf(0L));
            }
            if (issue.getWatches() == null) {
                issue.setWatches(Long.valueOf(0L));
            }
            WorkflowEntry entry = (WorkflowEntry)transientVars.get("entry");
            issue.setWorkflowId(Long.valueOf(entry.getId()));
            Step step = (Step)((WorkflowStore)transientVars.get("store")).findCurrentSteps(entry.getId()).get(0);
            WorkflowDescriptor descriptor = (WorkflowDescriptor)transientVars.get("descriptor");
            StepDescriptor stepDescriptor = descriptor.getStep(step.getStepId());
            issue.setStatusId((String)stepDescriptor.getMetaAttributes().get("jira.status.id"));
            issue.store();
            Map modifiedFields = issue.getModifiedFields();
            for (String fieldId : modifiedFields.keySet()) {
                if (!fieldManager.isOrderableField(fieldId)) continue;
                OrderableField field = fieldManager.getOrderableField(fieldId);
                Object newValue = ((ModifiedValue)modifiedFields.get(fieldId)).getNewValue();
                if (newValue == null) continue;
                field.createValue((Issue)issue, newValue);
            }
            issue.resetModifiedFields();
        }
        catch (StoreException e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public static FunctionDescriptor makeDescriptor() {
        FunctionDescriptor descriptor = DescriptorFactory.getFactory().createFunctionDescriptor();
        descriptor.setType("class");
        descriptor.getArgs().put("class.name", IssueCreateFunction.class.getName());
        return descriptor;
    }
}

