/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.tabs;

import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.jira.plugin.webfragment.DefaultWebFragmentContext;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.tabs.WorkflowTransitionTabProvider;
import com.atlassian.ozymandias.PluginPointFunction;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebPanelWorkflowTransitionTabProvider
implements WorkflowTransitionTabProvider {
    private static final String TAB_PANELS_LOCATION = "workflow.transition.tabs";
    private static final Logger log = LoggerFactory.getLogger(WebPanelWorkflowTransitionTabProvider.class);
    private final WebInterfaceManager webInterfaceManager;
    private Function<WebPanelModuleDescriptor, WorkflowTransitionTabProvider.WorkflowTransitionTab> function;

    public WebPanelWorkflowTransitionTabProvider(WebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
    }

    @Override
    public Iterable<WorkflowTransitionTabProvider.WorkflowTransitionTab> getTabs(ActionDescriptor action, JiraWorkflow workflow) {
        final Map<String, Object> context = this.createContext(action, workflow);
        Iterable<WebPanelModuleDescriptor> panels = this.getDisplayableWebPanelDescriptors(context);
        return ImmutableList.copyOf((Iterable)com.google.common.collect.Iterables.filter((Iterable)com.google.common.collect.Iterables.transform(panels, (Function)new Function<WebPanelModuleDescriptor, WorkflowTransitionTabProvider.WorkflowTransitionTab>(){

            public WorkflowTransitionTabProvider.WorkflowTransitionTab apply(final WebPanelModuleDescriptor input) {
                return (WorkflowTransitionTabProvider.WorkflowTransitionTab)SafePluginPointAccess.call((Callable)new Callable<WorkflowTransitionTabProvider.WorkflowTransitionTab>(){

                    @Override
                    public WorkflowTransitionTabProvider.WorkflowTransitionTab call() throws Exception {
                        String label = input.getWebLabel().getDisplayableLabel(ExecutingHttpRequest.get(), context);
                        String count = input.getWebParams().getRenderedParam("count", (Map)Maps.newHashMap((Map)context));
                        return new WorkflowTransitionTabProvider.WorkflowTransitionTab(label, count, input);
                    }
                }).getOrNull();
            }
        }), (Predicate)Predicates.notNull()));
    }

    private Map<String, Object> createContext(ActionDescriptor action, JiraWorkflow workflow) {
        ImmutableMap.Builder context = ImmutableMap.builder().putAll(DefaultWebFragmentContext.get((String)TAB_PANELS_LOCATION));
        if (action != null) {
            context.put((Object)"workflow_transition", (Object)action);
        }
        if (workflow != null) {
            context.put((Object)"workflow", (Object)workflow);
        }
        return context.build();
    }

    @Override
    @Nullable
    public String getTabContentHtml(final String panelKey, ActionDescriptor action, JiraWorkflow workflow) {
        final Map<String, Object> context = this.createContext(action, workflow);
        Iterable<WebPanelModuleDescriptor> panels = this.getDisplayableWebPanelDescriptors(context);
        Option tabDescriptor = Iterables.findFirst(panels, (Predicate)new Predicate<WebPanelModuleDescriptor>(){

            public boolean apply(WebPanelModuleDescriptor input) {
                return Objects.equal((Object)input.getKey(), (Object)panelKey);
            }
        });
        return (String)com.google.common.collect.Iterables.getFirst((Iterable)SafePluginPointAccess.to().descriptors((Iterable)tabDescriptor, (PluginPointFunction)new PluginPointFunction<WebPanelModuleDescriptor, WebPanel, String>(){

            public String onModule(WebPanelModuleDescriptor moduleDescriptor, WebPanel module) {
                return ((WebPanel)moduleDescriptor.getModule()).getHtml(context);
            }
        }), null);
    }

    private Iterable<WebPanelModuleDescriptor> getDisplayableWebPanelDescriptors(final Map<String, Object> context) {
        return com.google.common.collect.Iterables.filter((Iterable)((Iterable)SafePluginPointAccess.call((Callable)new Callable<List<WebPanelModuleDescriptor>>(){

            @Override
            public List<WebPanelModuleDescriptor> call() throws Exception {
                return WebPanelWorkflowTransitionTabProvider.this.webInterfaceManager.getDisplayableWebPanelDescriptors(WebPanelWorkflowTransitionTabProvider.TAB_PANELS_LOCATION, context);
            }
        }).getOrElse(Collections.emptyList())), (Predicate)Predicates.notNull());
    }
}

