/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.admin;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.admin.PropertyDescriptions;
import com.atlassian.jira.admin.PropertyPersister;
import com.atlassian.jira.admin.RenderableProperty;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.plugin.renderer.JiraRendererModuleDescriptor;
import com.atlassian.velocity.VelocityManager;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.velocity.exception.VelocityException;

@Internal
public final class RenderablePropertyImpl
implements RenderableProperty {
    private static final String EDIT_VM = "renderable-property-edit.vm";
    private final String templateDirectory = this.getClass().getPackage().getName().replace('.', '/');
    private final ApplicationProperties applicationProperties;
    private final PropertyPersister propertyPersister;
    private final PropertyDescriptions propertyDescription;
    private final FeatureManager featureManager;
    private final VelocityManager velocityManager;
    private final RendererManager rendererManager;

    RenderablePropertyImpl(ApplicationProperties applicationProperties, FeatureManager featureManager, VelocityManager velocityManager, RendererManager rendererManager, PropertyPersister propertyPersister, @Nullable PropertyDescriptions propertyDescriptions) {
        this.applicationProperties = applicationProperties;
        this.featureManager = featureManager;
        this.velocityManager = velocityManager;
        this.rendererManager = rendererManager;
        this.propertyPersister = propertyPersister;
        this.propertyDescription = propertyDescriptions != null ? propertyDescriptions : new EmptyDescriptions();
    }

    public final String getViewHtml() {
        if (this.isOnDemand()) {
            return this.rendererManager.getRenderedContent("atlassian-wiki-renderer", this.getValue(), null);
        }
        return this.getValue();
    }

    public final String getEditHtml(String fieldName) {
        if (this.isOnDemand()) {
            JiraRendererModuleDescriptor rendererDescriptor = this.rendererManager.getRendererForType("atlassian-wiki-renderer").getDescriptor();
            HashMap renderParams = Maps.newHashMap((Map)ImmutableMap.of((Object)"rows", (Object)"10", (Object)"cols", (Object)"60", (Object)"wrap", (Object)"virtual", (Object)"class", (Object)"long-field"));
            return rendererDescriptor.getEditVM(this.getValue(), null, "atlassian-wiki-renderer", fieldName, fieldName, (Map)renderParams, false);
        }
        return this.renderTemplate(EDIT_VM, new Context(fieldName));
    }

    public final String getDescriptionHtml() {
        if (this.isOnDemand()) {
            return this.propertyDescription.getOnDemandDescriptionHtml();
        }
        return this.propertyDescription.getBtfDescriptionHtml();
    }

    public final String getValue() {
        return this.propertyPersister.load();
    }

    public final void setValue(String value) {
        this.propertyPersister.save(value);
    }

    protected final boolean isOnDemand() {
        return this.featureManager.isOnDemand();
    }

    protected final boolean isBTF() {
        return !this.isOnDemand();
    }

    private String renderTemplate(String template, Context context) {
        String templatePath = this.templateDirectory + "/" + template;
        try {
            return this.velocityManager.getEncodedBody(templatePath, "", this.applicationProperties.getEncoding(), (Map)ImmutableMap.of((Object)"property", (Object)context));
        }
        catch (VelocityException e) {
            throw new RuntimeException("Error rendering " + templatePath, e);
        }
    }

    private static class EmptyDescriptions
    implements PropertyDescriptions {
        private EmptyDescriptions() {
        }

        @Override
        public String getOnDemandDescriptionHtml() {
            return "";
        }

        @Override
        public String getBtfDescriptionHtml() {
            return "";
        }
    }

    public class Context {
        private final String fieldName;

        public Context(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getValueHtml() {
            return StringEscapeUtils.escapeHtml((String)RenderablePropertyImpl.this.getValue());
        }
    }
}

