/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.core.util.FileSize;
import com.atlassian.core.util.thumbnail.Thumber;
import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.core.util.thumbnail.ThumbnailDimension;
import com.atlassian.fugue.Option;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImpl;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarPickerHelper;
import com.atlassian.jira.avatar.Selection;
import com.atlassian.jira.avatar.TemporaryAvatar;
import com.atlassian.jira.avatar.TypeAvatarService;
import com.atlassian.jira.avatar.UniversalAvatarsService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.LimitedOutputStream;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.util.FileNameCharacterCheckerUtil;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvatarPickerHelperImpl
implements AvatarPickerHelper {
    private static final Logger log = LoggerFactory.getLogger(AvatarPickerHelperImpl.class);
    private static final List<String> CONTENT_TYPES = Lists.newArrayList((Object[])new String[]{"image/jpeg", "image/gif", "image/png", "image/pjpeg", "image/x-png"});
    private static final int MAX_SIDE_LENGTH = 500;
    private static final String AVATAR_IMAGE_FORMAT = "png";
    private static final String TEMP_FILE_PREFIX = "JIRA-avatar";
    private static final String TEMP_FILE_EXTENSION = ".png";
    private static final int DEFAULT_MAX_MEGAPIXELS = 5;
    private final AvatarManager avatarManager;
    private final JiraAuthenticationContext authenticationContext;
    private final ApplicationProperties applicationProperties;
    private final VelocityRequestContextFactory requestContextFactory;
    private final UserUtil userUtil;
    private final Thumber thumber;
    private final UniversalAvatarsService universalAvatarsService;

    public AvatarPickerHelperImpl(AvatarManager avatarManager, JiraAuthenticationContext authenticationContext, ApplicationProperties properties, VelocityRequestContextFactory requestContextFactory, UserUtil userUtil, UniversalAvatarsService universalAvatarsService) {
        this.avatarManager = avatarManager;
        this.authenticationContext = authenticationContext;
        this.applicationProperties = properties;
        this.requestContextFactory = requestContextFactory;
        this.userUtil = userUtil;
        this.universalAvatarsService = universalAvatarsService;
        this.thumber = new Thumber(Thumbnail.MimeType.PNG);
    }

    @Override
    public Result<TemporaryAvatarBean> upload(InputStream stream, String fileName, String contentType, long size, String ownerId, Avatar.Type type) {
        if (!this.isAllowedToPickAvatar(ownerId, type)) {
            return new Result().addError(null, ErrorCollection.Reason.FORBIDDEN);
        }
        if (!this.isImageContent(contentType)) {
            if (fileName != null && !fileName.contains(".")) {
                log.info("Received avatar upload with unsupported content type: " + contentType + " and no extension");
                return new Result().addError(this.getText("avatarpicker.upload.contenttype.no.ext.failure"), ErrorCollection.Reason.VALIDATION_FAILED);
            }
            log.info("Received avatar upload with unsupported content type: " + contentType);
            return new Result().addError(this.getText("avatarpicker.upload.contenttype.failure"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        Result<File> copyResult = this.copyStreamToTempFile(stream, fileName, size);
        if (!copyResult.isValid()) {
            return new Result<TemporaryAvatarBean>(copyResult);
        }
        File file = copyResult.getResult();
        String invalidChars = new FileNameCharacterCheckerUtil().assertFileNameDoesNotContainInvalidChars(fileName);
        if (invalidChars == null) {
            BufferedImage image;
            ResultAndContentTypeChanged scaledFileAndContentType = this.clampSize(file, 500);
            Result<File> scaledFile = scaledFileAndContentType.getResult();
            if (!scaledFile.isValid()) {
                return new Result<TemporaryAvatarBean>(scaledFile);
            }
            try {
                image = this.thumber.getImage(scaledFile.getResult(), Predicates.alwaysTrue());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String temporaryContentType = scaledFileAndContentType.isContentTypeChanged() ? AvatarManager.AVATAR_IMAGE_FORMAT_FULL.getContentType() : contentType;
            TemporaryAvatar tempAvatar = new TemporaryAvatar(contentType, temporaryContentType, fileName, scaledFile.getResult(), null);
            ExecutingHttpRequest.get().getSession().setAttribute("tempAvatarFile", (Object)tempAvatar);
            return new Result<TemporaryAvatarBean>(new TemporaryAvatarBean(this.getTemporaryAvatarUrl(), ((Image)image).getWidth(null), ((Image)image).getHeight(null), this.isCroppingNeeded(image)));
        }
        return new Result().addError(this.getText("avatarpicker.upload.filename.failure", invalidChars), ErrorCollection.Reason.VALIDATION_FAILED);
    }

    @Override
    public Result<Avatar> convertTemporaryToReal(String ownerId, Avatar.Type type, Selection selection) {
        if (!this.isAllowedToPickAvatar(ownerId, type)) {
            return new Result().addError(null, ErrorCollection.Reason.FORBIDDEN);
        }
        TemporaryAvatar temporaryAvatar = (TemporaryAvatar)ExecutingHttpRequest.get().getSession().getAttribute("tempAvatarFile");
        if (temporaryAvatar == null) {
            return new Result().addError(this.getText("avatarpicker.upload.failure"), ErrorCollection.Reason.SERVER_ERROR);
        }
        int maxOffset = 500 - Avatar.Size.LARGE.getPixels();
        if (selection.getTopLeftX() < 0 || selection.getTopLeftY() < 0 || selection.getTopLeftX() > maxOffset || selection.getTopLeftY() > maxOffset) {
            return new Result().addError(this.getText("avatarpicker.upload.failure"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        Avatar newAvatar = this.getAvatar(temporaryAvatar, type, ownerId);
        try {
            newAvatar = this.avatarManager.create(newAvatar, (InputStream)new FileInputStream(temporaryAvatar.getFile()), selection);
        }
        catch (IOException e) {
            log.error("Unable to create avatar.", (Throwable)e);
            return new Result().addError(this.getText("avatarpicker.upload.temp.io", e.getMessage()), ErrorCollection.Reason.SERVER_ERROR);
        }
        if (temporaryAvatar.getFile().delete()) {
            log.debug("Deleted temporary avatar file " + temporaryAvatar.getFile().getAbsolutePath());
        } else {
            log.info("Couldn't delete temporary avatar file. Will retry on shutdown. " + temporaryAvatar.getFile().getAbsolutePath());
        }
        return new Result<Avatar>(newAvatar);
    }

    private Avatar getAvatar(TemporaryAvatar temporaryAvatar, Avatar.Type type, String ownerId) {
        return AvatarImpl.createCustomAvatar(temporaryAvatar.getOriginalFilename(), temporaryAvatar.getTemporaryContentType(), ownerId, type);
    }

    @Override
    public Result<TemporaryAvatarBean> cropTemporary(String ownerId, Avatar.Type type, Selection selection) {
        if (!this.isAllowedToPickAvatar(ownerId, type)) {
            return new Result().addError(null, ErrorCollection.Reason.FORBIDDEN);
        }
        TemporaryAvatar temporaryAvatar = (TemporaryAvatar)ExecutingHttpRequest.get().getSession().getAttribute("tempAvatarFile");
        if (temporaryAvatar == null) {
            return new Result().addError(this.getText("avatarpicker.upload.failure"), ErrorCollection.Reason.SERVER_ERROR);
        }
        TemporaryAvatar croppedAvatar = new TemporaryAvatar(temporaryAvatar.getContentType(), temporaryAvatar.getTemporaryContentType(), temporaryAvatar.getOriginalFilename(), temporaryAvatar.getFile(), selection);
        ExecutingHttpRequest.get().getSession().setAttribute("tempAvatarFile", (Object)croppedAvatar);
        return new Result<TemporaryAvatarBean>(new TemporaryAvatarBean(this.getTemporaryAvatarUrl(), selection));
    }

    private boolean isAllowedToPickAvatar(final String ownerId, Avatar.Type type) {
        final ApplicationUser user = this.authenticationContext.getUser();
        if (type == Avatar.Type.USER) {
            return this.avatarManager.hasPermissionToEdit(user, this.userUtil.getUserByKey(ownerId));
        }
        Option avatars = Option.option((Object)this.universalAvatarsService.getAvatars(type));
        Option canCreateAvatarOption = avatars.flatMap((Function)new Function<TypeAvatarService, Option<Boolean>>(){

            public Option<Boolean> apply(TypeAvatarService typeAvatarService) {
                return Option.some((Object)typeAvatarService.canUserCreateAvatar(user, ownerId));
            }
        });
        return (Boolean)canCreateAvatarOption.getOrElse((Object)Boolean.FALSE);
    }

    private boolean isCroppingNeeded(Image image) {
        return image.getWidth(null) > Avatar.Size.LARGE.getPixels() || image.getHeight(null) != image.getWidth(null);
    }

    private Result<File> copyStreamToTempFile(InputStream stream, String fileName, long size) {
        Result<File> fileResult = this.createTemporaryFile(null);
        if (!fileResult.isValid()) {
            return fileResult;
        }
        File tempFile = fileResult.getResult();
        LimitedOutputStream limitedOutput = null;
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(tempFile));
            if (size >= 0L) {
                limitedOutput = new LimitedOutputStream(new BufferedOutputStream(outputStream), size);
                outputStream = limitedOutput;
            }
            IOUtils.copy((InputStream)stream, (OutputStream)outputStream);
            ((OutputStream)outputStream).close();
            if (limitedOutput != null && limitedOutput.getCurrentLength() != size) {
                AvatarPickerHelperImpl.deleteFileIfExists(tempFile);
                String text = limitedOutput.getCurrentLength() == 0L ? this.getText("avatarpicker.upload.size.zero") : this.getText("avatarpicker.upload.size.wrong");
                return new Result().addError(text, ErrorCollection.Reason.VALIDATION_FAILED);
            }
            return fileResult;
        }
        catch (IOException e) {
            IOUtils.closeQuietly(outputStream);
            AvatarPickerHelperImpl.deleteFileIfExists(tempFile);
            if (e instanceof LimitedOutputStream.TooBigIOException) {
                LimitedOutputStream.TooBigIOException tooBigIOException = (LimitedOutputStream.TooBigIOException)e;
                return new Result().addError(this.getText("avatarpicker.upload.size.toobig", fileName, FileSize.format((long)tooBigIOException.getMaxSize())), ErrorCollection.Reason.VALIDATION_FAILED);
            }
            log.debug("I/O error occured while attaching file.", (Throwable)e);
            return new Result().addError(this.getText("attachfile.error.io.error", fileName, e.getMessage()), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private String getBaseUrl() {
        return this.requestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
    }

    private boolean isImageContent(String contentType) {
        return contentType != null && CONTENT_TYPES.contains(contentType.toLowerCase());
    }

    private ResultAndContentTypeChanged clampSize(File sourceFile, int edgeSize) {
        int maxPixels;
        int sourceWidth;
        BufferedImage sourceImage = null;
        try {
            sourceImage = this.thumber.getImage(sourceFile, Predicates.alwaysTrue());
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            new Result().addError(this.getText("avatarpicker.upload.image.corrupted"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (sourceImage == null) {
            return new ResultAndContentTypeChanged(new Result().addError(this.getText("avatarpicker.upload.image.corrupted"), ErrorCollection.Reason.VALIDATION_FAILED), false);
        }
        int sourceHeight = ((Image)sourceImage).getHeight(null);
        if (sourceHeight * (sourceWidth = ((Image)sourceImage).getWidth(null)) > (maxPixels = this.getMaxMegaPixels()) * 1000000) {
            return new ResultAndContentTypeChanged(new Result().addError(this.getText("avatarpicker.upload.too.big", maxPixels), ErrorCollection.Reason.VALIDATION_FAILED), false);
        }
        if (sourceHeight > edgeSize || sourceWidth > edgeSize) {
            return this.cropImageToFile(edgeSize, sourceImage);
        }
        return new ResultAndContentTypeChanged(new Result<File>(sourceFile), false);
    }

    private ResultAndContentTypeChanged cropImageToFile(int edgeSize, Image sourceImage) {
        Result<File> prescaledFile = this.createTemporaryFile(TEMP_FILE_EXTENSION);
        if (!prescaledFile.isValid()) {
            return new ResultAndContentTypeChanged(prescaledFile, false);
        }
        ThumbnailDimension dimensions = this.thumber.determineScaleSize(edgeSize, edgeSize, sourceImage.getWidth(null), sourceImage.getHeight(null));
        BufferedImage scaledImage = this.thumber.scaleImage(sourceImage, dimensions);
        try {
            ImageIO.write((RenderedImage)scaledImage, AVATAR_IMAGE_FORMAT, prescaledFile.getResult());
            return new ResultAndContentTypeChanged(prescaledFile, true);
        }
        catch (IOException e) {
            return new ResultAndContentTypeChanged(new Result().addError(this.getText("avatarpicker.upload.temp.io", e.getMessage()), ErrorCollection.Reason.SERVER_ERROR), false);
        }
    }

    private int getMaxMegaPixels() {
        String megaPixels = this.applicationProperties.getDefaultBackedString("jira.avatar.megapixels");
        if (StringUtils.isNotBlank((String)megaPixels) && StringUtils.isNumeric((String)megaPixels)) {
            return Integer.parseInt(megaPixels);
        }
        return 5;
    }

    @Override
    public String getTemporaryAvatarUrl() {
        return this.getBaseUrl() + "/secure/temporaryavatar?cropped=true&magic=" + System.currentTimeMillis();
    }

    private static void deleteFileIfExists(File file) {
        if (file.exists() && !file.delete()) {
            log.warn("Unable to delete file '" + file + "'.");
        }
    }

    private String getText(String text) {
        return this.authenticationContext.getI18nHelper().getText(text);
    }

    private String getText(String text, Object ... args) {
        return this.authenticationContext.getI18nHelper().getText(text, (Object)args);
    }

    private Result<File> createTemporaryFile(String suffix) {
        try {
            File tempFile = File.createTempFile(TEMP_FILE_PREFIX, suffix);
            tempFile.deleteOnExit();
            return new Result<File>(tempFile);
        }
        catch (IOException e) {
            return new Result().addError(this.getText("avatarpicker.upload.temp.fail"), ErrorCollection.Reason.SERVER_ERROR);
        }
    }

    public static class TemporaryAvatarBean {
        private final String url;
        private final boolean needsCropping;
        private int cropperWidth = -1;
        private int cropperOffsetX = -1;
        private int cropperOffsetY = -1;

        public TemporaryAvatarBean(String url, int width, int height, boolean needsCropping) {
            this.url = url;
            this.needsCropping = needsCropping;
            this.setCroppingCoordinates(width, height);
        }

        public TemporaryAvatarBean(String url, Selection selection) {
            this.url = url;
            this.needsCropping = true;
            this.setCroppingCoordinates(selection);
        }

        public boolean isCroppingNeeded() {
            return this.needsCropping;
        }

        public String getUrl() {
            return this.url;
        }

        public int getCropperWidth() {
            return this.cropperWidth;
        }

        public int getCropperOffsetX() {
            return this.cropperOffsetX;
        }

        public int getCropperOffsetY() {
            return this.cropperOffsetY;
        }

        private void setCroppingCoordinates(int width, int height) {
            int baseSize = Avatar.Size.LARGE.getPixels();
            this.cropperOffsetX = width <= baseSize ? 0 : (width - baseSize) / 5;
            this.cropperOffsetY = height <= baseSize ? 0 : (height - baseSize) / 5;
            if (this.cropperWidth == -1) {
                int minWidth = Math.min(width, height);
                this.cropperWidth = minWidth <= baseSize ? minWidth : baseSize + (minWidth - baseSize) / 3;
            }
        }

        private void setCroppingCoordinates(Selection selection) {
            this.cropperWidth = selection.getWidth();
            this.cropperOffsetX = selection.getTopLeftX();
            this.cropperOffsetY = selection.getTopLeftY();
        }
    }

    public static class Result<T> {
        ErrorCollection errorCollection = new SimpleErrorCollection();
        private T result;

        Result() {
        }

        Result(T t) {
            this.result = t;
        }

        Result(Result<?> result) {
            this.errorCollection = result.getErrorCollection();
        }

        public ErrorCollection getErrorCollection() {
            return this.errorCollection;
        }

        public T getResult() {
            return this.result;
        }

        public boolean isValid() {
            return !this.errorCollection.hasAnyErrors();
        }

        Result<T> setResult(T t) {
            this.result = t;
            return this;
        }

        Result<T> addError(String message, ErrorCollection.Reason reason) {
            this.errorCollection.addErrorMessage(message, reason);
            return this;
        }
    }

    static class ResultAndContentTypeChanged {
        private final Result<File> result;
        private final boolean contentTypeChanged;

        ResultAndContentTypeChanged(Result<File> result, boolean contentTypeChanged) {
            this.result = result;
            this.contentTypeChanged = contentTypeChanged;
        }

        public Result<File> getResult() {
            return this.result;
        }

        public boolean isContentTypeChanged() {
            return this.contentTypeChanged;
        }
    }
}

