/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.admin;

import com.atlassian.jira.config.properties.ExampleGenerator;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.validation.ApplicationPropertyEnumerator;
import com.atlassian.validation.BooleanValidator;
import com.atlassian.validation.IntegerValidator;
import com.atlassian.validation.NonValidator;
import com.atlassian.validation.Validator;
import com.atlassian.validation.ValidatorFactory;
import com.google.common.base.Supplier;
import java.util.HashMap;
import java.util.Map;

public class ApplicationPropertyMetadata {
    private static final Map<String, Validator> DEFAULT_VALIDATORS_BY_TYPE = new HashMap<String, Validator>();
    private String key;
    private String type;
    private String defaultValue;
    private Supplier<? extends Validator> validator;
    private boolean advancedSetting;
    private boolean sysadminEditable;
    private boolean adminEditable;
    private boolean requiresRestart;
    private String name;
    private String nameKey;
    private String desc;
    private String descKey;
    private ExampleGenerator exampleGenerator;
    private ApplicationPropertyEnumerator enumerator;
    private Pair<String, Boolean> requiredFeatureKey;

    private static Supplier<Validator> validatorResolver(final String type) {
        return new LazyReference<Validator>(){

            protected Validator create() throws Exception {
                Validator validator = (Validator)DEFAULT_VALIDATORS_BY_TYPE.get(type);
                if (validator == null) {
                    validator = new NonValidator();
                }
                return validator;
            }
        };
    }

    private ApplicationPropertyMetadata(String key, String type, String defaultValue, Supplier<? extends Validator> validatorSupplier, boolean advancedSetting, boolean sysadminEditable, boolean adminEditable, boolean requiresRestart, String name, String nameKey, String desc, String descKey, ExampleGenerator exampleGenerator, ApplicationPropertyEnumerator enumerator, Pair<String, Boolean> requiredFeatureKey) {
        this.key = key;
        this.type = type;
        this.defaultValue = defaultValue;
        this.advancedSetting = advancedSetting;
        this.sysadminEditable = sysadminEditable;
        this.adminEditable = adminEditable;
        this.requiresRestart = requiresRestart;
        this.name = name;
        this.nameKey = nameKey;
        this.desc = desc;
        this.descKey = descKey;
        this.validator = validatorSupplier;
        this.exampleGenerator = exampleGenerator;
        this.enumerator = enumerator;
        this.requiredFeatureKey = requiredFeatureKey;
    }

    public String getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isAdvancedSetting() {
        return this.advancedSetting;
    }

    public boolean isSysadminEditable() {
        return this.sysadminEditable;
    }

    public boolean isRequiresRestart() {
        return this.requiresRestart;
    }

    public String getName() {
        return this.name;
    }

    public String getNameKey() {
        return this.nameKey;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getDescriptionKey() {
        return this.descKey;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Validator getValidator() {
        return (Validator)this.validator.get();
    }

    public ApplicationPropertyEnumerator getEnumerator() {
        if (!"enum".equals(this.type)) {
            throw new IllegalStateException("Tried to get enumerator for a non-enum type");
        }
        return this.enumerator;
    }

    public Validator.Result validate(String value) {
        return ((Validator)this.validator.get()).validate(value);
    }

    public boolean isAdminEditable() {
        return this.adminEditable;
    }

    public ExampleGenerator getExampleGenerator() {
        return this.exampleGenerator;
    }

    public Pair<String, Boolean> getRequiredFeatureKey() {
        return this.requiredFeatureKey;
    }

    static {
        DEFAULT_VALIDATORS_BY_TYPE.put("string", new NonValidator());
        DEFAULT_VALIDATORS_BY_TYPE.put("uint", new IntegerValidator(0, Integer.MAX_VALUE));
        DEFAULT_VALIDATORS_BY_TYPE.put("int", new IntegerValidator());
        DEFAULT_VALIDATORS_BY_TYPE.put("boolean", new BooleanValidator());
    }

    public static class Builder {
        private String key;
        private String type;
        private String defaultValue;
        private Supplier<? extends Validator> validator;
        private boolean advancedSetting;
        private boolean sysAdminEditable;
        private boolean adminEditable;
        private boolean requiresRestart;
        private String name;
        private String nameKey;
        private String desc;
        private String descKey;
        private ApplicationPropertyEnumerator enumerator;
        private ExampleGenerator exampleGenerator;
        private Pair<String, Boolean> requiredFeatureKeys;

        public String key() {
            return this.key;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public String type() {
            return this.type;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public String defaultValue() {
            return this.defaultValue;
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Supplier<? extends Validator> validator() {
            return this.validator;
        }

        public Builder validatorName(String validatorName) {
            this.validator = validatorName == null ? ApplicationPropertyMetadata.validatorResolver(this.type) : new ValidatorFactory().getInstanceLazyReference(validatorName);
            return this;
        }

        public Builder validator(Supplier<? extends Validator> validator) {
            this.validator = validator;
            return this;
        }

        public boolean sysAdminEditable() {
            return this.sysAdminEditable;
        }

        public Builder sysAdminEditable(boolean sysAdminEditable) {
            this.sysAdminEditable = sysAdminEditable;
            return this;
        }

        public boolean adminEditable() {
            return this.adminEditable;
        }

        public Builder adminEditable(boolean adminEditable) {
            this.adminEditable = adminEditable;
            return this;
        }

        public boolean requiresRestart() {
            return this.requiresRestart;
        }

        public Builder requiresRestart(boolean requiresRestart) {
            this.requiresRestart = requiresRestart;
            return this;
        }

        public String name() {
            return this.name;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public String nameKey() {
            return this.nameKey;
        }

        public Builder nameKey(String nameKey) {
            this.nameKey = nameKey;
            return this;
        }

        public String desc() {
            return this.desc;
        }

        public Builder desc(String desc) {
            this.desc = desc;
            return this;
        }

        public String descKey() {
            return this.descKey;
        }

        public Builder descKey(String descKey) {
            this.descKey = descKey;
            return this;
        }

        public ApplicationPropertyEnumerator enumerator() {
            return this.enumerator;
        }

        public Builder enumerator(ApplicationPropertyEnumerator enumerator) {
            this.enumerator = enumerator;
            return this;
        }

        public ApplicationPropertyMetadata build() {
            return new ApplicationPropertyMetadata(this.key, this.type, this.defaultValue, this.validator, this.advancedSetting, this.sysAdminEditable, this.adminEditable, this.requiresRestart, this.name, this.nameKey, this.desc, this.descKey, this.exampleGenerator, this.enumerator, this.requiredFeatureKeys);
        }

        public Builder exampleGenerator(ExampleGenerator exampleGenerator) {
            this.exampleGenerator = exampleGenerator;
            return this;
        }

        public Builder requiredFeatureKey(Pair<String, Boolean> requiredFeatureKeys) {
            this.requiredFeatureKeys = requiredFeatureKeys;
            return this;
        }

        public Builder advancedSetting(boolean advancedSetting) {
            this.advancedSetting = advancedSetting;
            return this;
        }
    }
}

