/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.group;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupRelationshipChecker {
    private static final Logger log = LoggerFactory.getLogger(GroupRelationshipChecker.class);
    private final DirectoryManager directoryManager;

    public GroupRelationshipChecker(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public boolean isGroupEqualOrNested(Optional<Long> userDirectoryId, String checkedGroup, String referenceGroup) {
        return userDirectoryId.map(id -> this.isGroupEqualOrNested((long)id, checkedGroup, referenceGroup)).orElse(this.isGroupEqual(checkedGroup, referenceGroup));
    }

    private boolean isGroupEqualOrNested(long userDirectoryId, String checkedGroup, String referenceGroup) {
        return this.isGroupEqual(checkedGroup, referenceGroup) || this.isGivenGroupNestedGroup(userDirectoryId, referenceGroup, checkedGroup);
    }

    private boolean isGroupEqual(String group1, String group2) {
        return IdentifierUtils.equalsInLowerCase((String)group1, (String)group2);
    }

    private boolean isGivenGroupNestedGroup(long directory, String parentGroup, String childGroup) {
        try {
            return this.directoryManager.isGroupNestedGroupMember(directory, childGroup, parentGroup);
        }
        catch (DirectoryNotFoundException e) {
            log.warn("Could not find directory with id {}", (Object)directory);
            return false;
        }
        catch (OperationFailedException e) {
            log.warn("Group inheritance check failed", (Throwable)e);
            return false;
        }
    }
}

