/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.subtask.conversion;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.subtask.conversion.DefaultIssueConversionService;
import com.atlassian.jira.bc.subtask.conversion.IssueToSubTaskConversionService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.event.issue.IssueEventBundleFactory;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.workflow.WorkflowManager;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIssueToSubTaskConversionService
extends DefaultIssueConversionService
implements IssueToSubTaskConversionService {
    private static final Logger log = LoggerFactory.getLogger(DefaultIssueToSubTaskConversionService.class);
    private final PermissionManager permissionManager;
    private final SubTaskManager subtaskManager;

    public DefaultIssueToSubTaskConversionService(PermissionManager permissionManager, SubTaskManager subtaskManager, IssueTypeSchemeManager issueTypeSchemeManager, JiraAuthenticationContext jiraAuthenticationContext, WorkflowManager workflowManager, FieldLayoutManager fieldLayoutManager, FieldManager fieldManager, IssueEventManager issueEventManager, IssueEventBundleFactory issueEventBundleFactory) {
        super(permissionManager, workflowManager, fieldLayoutManager, issueTypeSchemeManager, jiraAuthenticationContext, fieldManager, issueEventManager, issueEventBundleFactory);
        this.permissionManager = permissionManager;
        this.subtaskManager = subtaskManager;
    }

    public boolean canConvertIssue(JiraServiceContext context, Issue issue) {
        if (context == null) {
            throw new IllegalArgumentException("Operation is out of context");
        }
        if (issue == null) {
            throw new IllegalArgumentException("Issue not specified");
        }
        ApplicationUser user = context.getLoggedInUser();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (!this.areSubTasksEnabled()) {
            errorCollection.addErrorMessage(this.getText("convert.issue.to.subtask.errormessage.subtasksdisabled"));
        }
        if (!this.hasPermission(context, issue)) {
            if (Users.isAnonymous((ApplicationUser)user)) {
                errorCollection.addErrorMessage(this.getText("convert.issue.to.subtask.errormessage.nopermissionanon"));
            } else {
                errorCollection.addErrorMessage(this.getText("convert.issue.to.subtask.errormessage.nopermisionuser"));
            }
        }
        if (issue.isSubTask()) {
            errorCollection.addErrorMessage(this.getText("convert.issue.to.subtask.errormessage.subtaskalready", issue.getKey()));
        }
        if (this.hasIssueSubTasks(issue)) {
            errorCollection.addErrorMessage(this.getText("convert.issue.to.subtask.errormessage.issuehassubtasks", issue.getKey()));
        }
        if (!this.projectHasSubTasks(issue.getProjectObject())) {
            errorCollection.addErrorMessage(this.getText("convert.issue.to.subtask.errormessage.nosubtaskissuetypesforproject", issue.getProjectObject().getKey()));
        }
        context.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
        return !errorCollection.hasAnyErrors();
    }

    public void validateTargetIssueType(JiraServiceContext context, Issue issue, IssueType issueType, String fieldNameIssueTypeId) {
        Collection issueTypes;
        ErrorCollection errorCollection = context.getErrorCollection();
        if (!issueType.isSubTask()) {
            errorCollection.addError(fieldNameIssueTypeId, this.getText("convert.issue.to.subtask.error.issuetypenotsubtask", issueType.getName()));
        }
        if (!this.containsIssueTypeWithSameId(issueTypes = this.issueTypeSchemeManager.getIssueTypesForProject(issue.getProjectObject()), issueType.getId())) {
            errorCollection.addError(fieldNameIssueTypeId, this.getText("convert.issue.to.subtask.error.issuetypenotforproject", issueType.getName()));
        }
    }

    private boolean containsIssueTypeWithSameId(Collection<IssueType> issueTypes, String issueTypeId) {
        for (IssueType type : issueTypes) {
            if (!type.getId().equals(issueTypeId)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean canIssueSecurityFieldIgnore() {
        return true;
    }

    public void validateParentIssue(JiraServiceContext context, Issue issue, Issue parentIssue, String fieldNameParentIssueKey) {
        ErrorCollection errorCollection = context.getErrorCollection();
        if (parentIssue.isSubTask()) {
            errorCollection.addError(fieldNameParentIssueKey, this.getText("convert.issue.to.subtask.error.parentissubtask", parentIssue.getKey()));
        }
        if (parentIssue.getId().equals(issue.getId())) {
            errorCollection.addError(fieldNameParentIssueKey, this.getText("convert.issue.to.subtask.error.parentsameissue", parentIssue.getKey()));
        }
        if (!parentIssue.getProjectId().equals(issue.getProjectId())) {
            errorCollection.addError(fieldNameParentIssueKey, this.getText("convert.issue.to.subtask.error.differentproject", parentIssue.getKey(), issue.getKey()));
        }
        if (!this.permissionManager.hasPermission(10, parentIssue, context.getLoggedInApplicationUser())) {
            errorCollection.addError(fieldNameParentIssueKey, this.getText("convert.issue.to.subtask.error.invalidparentissuekey", parentIssue.getKey()));
        }
        if (!parentIssue.isEditable()) {
            errorCollection.addError(fieldNameParentIssueKey, this.getText("convert.issue.to.subtask.error.parentnoteditable", parentIssue.getKey()));
        }
    }

    public void preStoreUpdates(JiraServiceContext context, IssueChangeHolder changeHolder, Issue currentIssue, MutableIssue targetIssue) {
        Issue parentIssue = targetIssue.getParentObject();
        changeHolder.addChangeItem(new ChangeItemBean("jira", "Parent", null, null, parentIssue.getId().toString(), parentIssue.getKey()));
        this.updateTargetIssueSecurityLevel(changeHolder, currentIssue, targetIssue, parentIssue);
        try {
            this.subtaskManager.createSubTaskIssueLink(parentIssue, (Issue)targetIssue, context.getLoggedInUser());
        }
        catch (CreateException e) {
            String msg = "Could not create sub-task issue link for '" + targetIssue.getKey() + "' (issue) and '" + parentIssue.getKey() + "' (parent)";
            log.error(msg, (Throwable)e);
            throw new DataAccessException(msg, (Throwable)e);
        }
    }

    private void updateTargetIssueSecurityLevel(IssueChangeHolder changeHolder, Issue currentIssue, MutableIssue targetIssue, Issue parentIssue) {
        targetIssue.setSecurityLevel(parentIssue.getSecurityLevel());
        Long targetSecurityLevelId = targetIssue.getSecurityLevelId();
        Long currentSecurityLevelId = currentIssue.getSecurityLevelId();
        Long parentSecurityLevelId = parentIssue.getSecurityLevelId();
        if (DefaultIssueToSubTaskConversionService.isNotNullAndNotEqualTo(targetSecurityLevelId, parentSecurityLevelId) || DefaultIssueToSubTaskConversionService.isNotNullAndNotEqualTo(currentSecurityLevelId, parentSecurityLevelId)) {
            changeHolder.addChangeItem(new ChangeItemBean("jira", "security", DefaultIssueToSubTaskConversionService.getLongToStringNullSafe(currentSecurityLevelId), DefaultIssueToSubTaskConversionService.getIssueNameNullSafe(currentIssue), DefaultIssueToSubTaskConversionService.getLongToStringNullSafe(targetSecurityLevelId), DefaultIssueToSubTaskConversionService.getIssueNameNullSafe((Issue)targetIssue)));
        }
    }

    protected static boolean isNotNullAndNotEqualTo(Long id1, Long id2) {
        return id1 != null && !id1.equals(id2);
    }

    private static String getIssueNameNullSafe(Issue issue) {
        return issue.getSecurityLevel() == null ? null : issue.getSecurityLevel().getString("name");
    }

    protected static String getLongToStringNullSafe(Long aLong) {
        return aLong == null ? null : aLong.toString();
    }

    private boolean areSubTasksEnabled() {
        return this.subtaskManager.isSubTasksEnabled();
    }

    private boolean hasIssueSubTasks(Issue issue) {
        return !issue.getSubTaskObjects().isEmpty();
    }

    protected boolean projectHasSubTasks(Project project) {
        return !this.issueTypeSchemeManager.getSubTaskIssueTypesForProject(project).isEmpty();
    }
}

