/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.board.store;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.board.Board;
import com.atlassian.jira.board.BoardCreationData;
import com.atlassian.jira.board.BoardId;
import com.atlassian.jira.board.store.BoardStore;
import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.model.querydsl.BoardDTO;
import com.atlassian.jira.model.querydsl.QBoard;
import com.atlassian.jira.model.querydsl.QBoardProject;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import java.util.List;
import java.util.Optional;

public class QueryDslBoardStore
implements BoardStore {
    private static final String BOARD_ENTITY_NAME = "Board";
    private static final String BOARD_PROJECT_ENTITY_NAME = "BoardProject";
    private static final QBoard BOARD = new QBoard("Board");
    private static final QBoardProject BOARD_PROJECT = new QBoardProject("BoardProject");
    private final DbConnectionManager dbConnectionManager;
    private final OfBizDelegator ofBizDelegator;

    public QueryDslBoardStore(DbConnectionManager dbConnectionManager, OfBizDelegator ofBizDelegator) {
        this.dbConnectionManager = dbConnectionManager;
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public Board createBoard(BoardCreationData boardCreationData) {
        Long nextSeqId = this.ofBizDelegator.getDelegatorInterface().getNextSeqId(BOARD_ENTITY_NAME);
        this.dbConnectionManager.execute(dbConnection -> {
            dbConnection.setAutoCommit(false);
            try {
                dbConnection.insert(BOARD).set((Path)QueryDslBoardStore.BOARD.id, nextSeqId).set((Path)QueryDslBoardStore.BOARD.jql, boardCreationData.getJql()).execute();
                dbConnection.insert(BOARD_PROJECT).set((Path)QueryDslBoardStore.BOARD_PROJECT.boardId, nextSeqId).set((Path)QueryDslBoardStore.BOARD_PROJECT.projectId, (Object)boardCreationData.getProjectId()).execute();
            }
            finally {
                dbConnection.commit();
            }
        });
        return this.getBoard(new BoardId(nextSeqId.longValue())).get();
    }

    @Override
    public Optional<Board> getBoard(BoardId boardId) {
        BoardDTO boardDto = this.dbConnectionManager.executeQuery(dbConnection -> (BoardDTO)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().from((Expression)BOARD)).where((Predicate)QueryDslBoardStore.BOARD.id.eq((Object)boardId.getId()))).singleResult((Expression)BOARD));
        if (boardDto == null) {
            return Optional.empty();
        }
        return Optional.of(new Board(new BoardId(boardDto.getId().longValue()), boardDto.getJql()));
    }

    @Override
    public boolean deleteBoard(BoardId boardId) {
        long deletedRecords = this.dbConnectionManager.executeQuery(dbConnection -> {
            dbConnection.setAutoCommit(false);
            long count = dbConnection.delete((RelationalPath<?>)BOARD).where((Predicate)QueryDslBoardStore.BOARD.id.eq((Object)boardId.getId())).execute();
            dbConnection.delete((RelationalPath<?>)BOARD_PROJECT).where((Predicate)QueryDslBoardStore.BOARD_PROJECT.boardId.eq((Object)boardId.getId())).execute();
            dbConnection.commit();
            return count;
        });
        return deletedRecords == 1L;
    }

    @Override
    public List<Board> getBoardsForProject(long projectId) {
        List boardDtos = this.dbConnectionManager.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().from((Expression)BOARD)).innerJoin((EntityPath)BOARD_PROJECT)).on((Predicate)QueryDslBoardStore.BOARD.id.eq(QueryDslBoardStore.BOARD_PROJECT.boardId))).where((Predicate)QueryDslBoardStore.BOARD_PROJECT.projectId.eq((Object)projectId))).list((Expression)BOARD));
        return (List)boardDtos.stream().map(boardDto -> new Board(new BoardId(boardDto.getId().longValue()), boardDto.getJql())).collect(CollectorsUtil.toImmutableList());
    }

    @Override
    public boolean hasBoardForProject(long projectId) {
        long count = this.dbConnectionManager.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().from((Expression)BOARD)).innerJoin((EntityPath)BOARD_PROJECT)).where((Predicate)QueryDslBoardStore.BOARD_PROJECT.projectId.eq((Object)projectId))).count());
        return count > 0L;
    }
}

