/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.monitor;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.cache.CacheStatisticsKey;
import com.google.common.collect.ImmutableMap;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.Map;

@EventName(value="jira.cache.stats")
public class CacheStatisticsAnalyticEvent {
    private static final Long INITIAL_CACHE_VALUE = 0L;
    private final String name;
    private final ImmutableMap<CacheStatisticsKey, Long> stats;

    public CacheStatisticsAnalyticEvent(String name, Map<CacheStatisticsKey, Long> stats) {
        this.name = name;
        this.stats = ImmutableMap.copyOf(stats);
    }

    public String getName() {
        return this.name;
    }

    public Long getCacheSize() {
        return this.getStatistics(CacheStatisticsKey.SIZE);
    }

    public Long getUptime() {
        return ManagementFactory.getRuntimeMXBean().getUptime();
    }

    public Long getEvictionCount() {
        return this.getStatistics(CacheStatisticsKey.EVICTION_COUNT);
    }

    public Long getHitCount() {
        return this.getStatistics(CacheStatisticsKey.HIT_COUNT);
    }

    public Long getMissCount() {
        return this.getStatistics(CacheStatisticsKey.MISS_COUNT);
    }

    public Long getPutCount() {
        return this.getStatistics(CacheStatisticsKey.PUT_COUNT);
    }

    public Long getRemoveCount() {
        return this.getStatistics(CacheStatisticsKey.REMOVE_COUNT);
    }

    public Long getTotalMissTime() {
        return Duration.ofNanos(this.getStatistics(CacheStatisticsKey.TOTAL_MISS_TIME)).toMillis();
    }

    private Long getStatistics(CacheStatisticsKey key) {
        return (Long)this.stats.getOrDefault((Object)key, (Object)INITIAL_CACHE_VALUE);
    }
}

