/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.slomo;

import com.atlassian.cache.CachedReference;
import com.atlassian.cache.CachedReferenceListener;
import com.atlassian.cache.ManagedCache;
import com.atlassian.jira.cache.slomo.SloMoCacheManager;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class SloMoCachedReference<V>
implements CachedReference<V> {
    private static final Logger LOG = LoggerFactory.getLogger(SloMoCachedReference.class);
    private final SloMoCacheManager manager;
    private final CachedReference<V> delegate;

    public SloMoCachedReference(SloMoCacheManager manager, CachedReference<V> delegate) {
        this.manager = manager;
        this.delegate = delegate;
    }

    @Nonnull
    public V get() {
        this.manager.sleep();
        return (V)this.delegate.get();
    }

    public void reset() {
        this.manager.sleep();
        this.delegate.reset();
    }

    public void addListener(CachedReferenceListener<V> listener, boolean includeValues) {
        LOG.warn("CachedReferenceListener for '{}' will not be supported by VCache", (Object)((ManagedCache)this.delegate).getName(), (Object)new IllegalArgumentException("Added here"));
        this.delegate.addListener(listener, includeValues);
    }

    public void removeListener(CachedReferenceListener<V> listener) {
        this.delegate.removeListener(listener);
    }
}

