/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.soy;

import com.atlassian.jira.cache.soy.Apdex517DarkFeatures;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.warmer.JiraWarmer;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.output.NullWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoyCacheWarmer
implements JiraWarmer {
    private static final Logger log = LoggerFactory.getLogger(SoyCacheWarmer.class);
    private final SoyTemplateRendererProvider soyTemplateRendererProvider;

    public SoyCacheWarmer(SoyTemplateRendererProvider soyTemplateRendererProvider) {
        this.soyTemplateRendererProvider = soyTemplateRendererProvider;
    }

    @Override
    public void run() {
        if (Apdex517DarkFeatures.warmHardcodedSet()) {
            this.warm(Apdex517DarkFeatures.getHardcodedModulesSet());
        }
    }

    private void warm(Set<String> modulesToWarm) {
        long warmStartTime = System.currentTimeMillis();
        log.info("Warming {} modules", (Object)modulesToWarm.size());
        for (String completeModuleKey : modulesToWarm) {
            long startTime = System.currentTimeMillis();
            try {
                this.soyTemplateRendererProvider.getRenderer().render((Appendable)new NullWriter(), completeModuleKey, "", Collections.emptyMap());
            }
            catch (Exception e) {
                log.debug("Caught exception while compiling {} : {}", (Object)completeModuleKey, (Object)e.getMessage());
            }
            long compileTime = System.currentTimeMillis() - startTime;
            log.debug("Compiled {} in {} ms", (Object)completeModuleKey, (Object)compileTime);
        }
        long warmCompleteTime = System.currentTimeMillis() - warmStartTime;
        log.info("Warming {} modules completed in {} ms", (Object)modulesToWarm.size(), (Object)warmCompleteTime);
    }
}

