/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.charts.jfreechart.ChartHelper;
import com.atlassian.jira.charts.jfreechart.HistogramChartGenerator;
import com.atlassian.jira.charts.jfreechart.util.ChartUtil;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.charts.util.DataUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.statistics.util.FieldableDocumentHitCollector;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.LuceneUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.Query;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.MapFieldSelector;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

class AverageAgeChart {
    private final SearchProvider searchProvider;
    private final IssueIndexManager issueIndexManager;
    private final TimeZone chartTimeZone;

    public AverageAgeChart(SearchProvider searchProvider, IssueIndexManager issueIndexManager, TimeZone chartTimeZone) {
        this.searchProvider = searchProvider;
        this.issueIndexManager = issueIndexManager;
        this.chartTimeZone = chartTimeZone;
    }

    public Chart generateChart(ApplicationUser remoteUser, SearchRequest searchRequest, int days, ChartFactory.PeriodName periodName, int width, int height) {
        return this.generateChartInternal(remoteUser, searchRequest, days, periodName, width, height, false);
    }

    public Chart generateInlineChart(ApplicationUser remoteUser, SearchRequest searchRequest, int days, ChartFactory.PeriodName periodName, int width, int height) {
        return this.generateChartInternal(remoteUser, searchRequest, days, periodName, width, height, true);
    }

    private Chart generateChartInternal(ApplicationUser remoteUser, SearchRequest searchRequest, int days, ChartFactory.PeriodName periodName, int width, int height, boolean inline) {
        Assertions.notNull((String)"searchRequest", (Object)searchRequest);
        days = DataUtils.normalizeDaysValue((int)days, (ChartFactory.PeriodName)periodName);
        try {
            SearchRequest clonedSr = this.getModifiedSearchRequest(searchRequest, days);
            TimeSeriesCollection dataset = this.getAverageAge(clonedSr, remoteUser, periodName, days);
            I18nBean i18nBean = this.getI18n(remoteUser);
            TimeSeriesCollection chartDataset = DataUtils.reduceDataset((TimeSeriesCollection)dataset, (List)Lists.newArrayList((Object[])new String[]{i18nBean.getText("datacollector.averageage")}));
            ChartHelper helper = new HistogramChartGenerator(chartDataset, i18nBean.getText("datacollector.days"), i18nBean).generateChart();
            JFreeChart chart = helper.getChart();
            XYPlot plot = (XYPlot)chart.getPlot();
            XYBarRenderer renderer = (XYBarRenderer)plot.getRenderer();
            renderer.setToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{1}: {2} " + i18nBean.getText("datacollector.daysunresolved"), (DateFormat)new SimpleDateFormat("dd-MMMMM-yyyy", i18nBean.getLocale()), NumberFormat.getInstance()));
            plot.setRenderer((XYItemRenderer)renderer);
            if (inline) {
                helper.generateInline(width, height);
            } else {
                helper.generate(width, height);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("chart", helper.getLocation());
            params.put("chartDataset", chartDataset);
            params.put("completeDataset", dataset);
            params.put("daysPrevious", days);
            params.put("period", periodName.toString());
            params.put("imagemap", helper.getImageMap());
            params.put("imagemapName", helper.getImageMapName());
            if (inline) {
                String base64Image = ((ChartUtils)ComponentAccessor.getComponent(ChartUtils.class)).renderBase64Chart(helper.getImage(), "Average Age Chart");
                params.put("base64Image", base64Image);
            }
            return new Chart(helper.getLocation(), helper.getImageMap(), helper.getImageMapName(), params);
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating chart", e);
        }
        catch (SearchException e) {
            throw new RuntimeException("Error generating chart", e);
        }
    }

    public TimeSeriesCollection getAverageAge(SearchRequest searchRequest, ApplicationUser remoteUser, ChartFactory.PeriodName periodName, int days) throws IOException, SearchException {
        Class timePeriodClass = ChartUtil.getTimePeriodClass((ChartFactory.PeriodName)periodName);
        TreeMap<RegularTimePeriod, Long> ageTotals = new TreeMap<RegularTimePeriod, Long>();
        TreeMap<RegularTimePeriod, Long> ageCounts = new TreeMap<RegularTimePeriod, Long>();
        this.searchProvider.search(searchRequest != null ? searchRequest.getQuery() : null, remoteUser, (Collector)new AverageAgeHitCollector("created", "resolutiondate", ageTotals, ageCounts, this.issueIndexManager.getIssueSearcher(), timePeriodClass, days, this.getCurrentTime(), this.chartTimeZone));
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        I18nBean i18nBean = this.getI18n(remoteUser);
        TimeSeries countSeries = new TimeSeries((Comparable)((Object)i18nBean.getText("datacollector.issuesunresolvedcapital")), timePeriodClass);
        TimeSeries totalSeries = new TimeSeries((Comparable)((Object)i18nBean.getText("datacollector.totalage")), timePeriodClass);
        TimeSeries averageSeries = new TimeSeries((Comparable)((Object)i18nBean.getText("datacollector.averageage")), timePeriodClass);
        for (RegularTimePeriod period : ageTotals.keySet()) {
            Long ageTotalLong = (Long)ageTotals.get(period);
            long total = ageTotals.get(period) == null ? 0L : ageTotalLong;
            Long ageCountLong = (Long)ageCounts.get(period);
            long count = ageCountLong == null ? 0L : ageCountLong;
            long average = 0L;
            if (count > 0L) {
                average = total / count;
            }
            countSeries.add(period, (double)count);
            totalSeries.add(period, (double)(total / DateUtils.DAY_MILLIS));
            averageSeries.add(period, (double)(average / DateUtils.DAY_MILLIS));
        }
        dataset.addSeries(countSeries);
        dataset.addSeries(totalSeries);
        dataset.addSeries(averageSeries);
        return dataset;
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }

    private SearchRequest getModifiedSearchRequest(SearchRequest searchRequest, int days) {
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder((Query)searchRequest.getQuery());
        queryBuilder.where().defaultAnd().sub().resolutionDate().gtEq().string("-" + days + "d").or().unresolved().endsub();
        return new SearchRequest(queryBuilder.buildQuery());
    }

    I18nBean getI18n(ApplicationUser user) {
        return new I18nBean(user);
    }

    static class AverageAgeHitCollector
    extends FieldableDocumentHitCollector {
        private final String createdDateConstant;
        private final String resolvedDateConstant;
        private final Map<RegularTimePeriod, Long> totalTimes;
        private final Map<RegularTimePeriod, Long> totalCounts;
        private final Class timePeriodClass;
        private final int days;
        private final Long currentTime;
        private final TimeZone timeZone;
        private final FieldSelector fieldSelector;

        public AverageAgeHitCollector(String createdDateConstant, String resolvedDateConstant, Map<RegularTimePeriod, Long> totalTime, Map<RegularTimePeriod, Long> totalCount, IndexSearcher searcher, Class timePeriodClass, int days, Long currentTime, TimeZone timeZone) {
            super(searcher);
            this.createdDateConstant = createdDateConstant;
            this.resolvedDateConstant = resolvedDateConstant;
            this.totalTimes = totalTime;
            this.totalCounts = totalCount;
            this.timePeriodClass = timePeriodClass;
            this.days = days;
            this.currentTime = currentTime;
            this.timeZone = timeZone;
            this.fieldSelector = new MapFieldSelector(new String[]{createdDateConstant, resolvedDateConstant});
        }

        protected FieldSelector getFieldSelector() {
            return this.fieldSelector;
        }

        public void collect(Document document) {
            Date creationDate = LuceneUtils.stringToDate((String)document.get(this.createdDateConstant));
            Date resolutionDate = null;
            String resolutionDateStr = document.get(this.resolvedDateConstant);
            if (resolutionDateStr != null) {
                resolutionDate = LuceneUtils.stringToDate((String)resolutionDateStr);
            }
            Calendar cal = Calendar.getInstance(this.timeZone);
            cal.setTimeInMillis(this.currentTime);
            cal.add(5, -(this.days - 1));
            Date earliest = cal.getTime();
            RegularTimePeriod end = RegularTimePeriod.createInstance((Class)this.timePeriodClass, (Date)new Date(this.currentTime), (TimeZone)this.timeZone);
            for (RegularTimePeriod cursor = RegularTimePeriod.createInstance((Class)this.timePeriodClass, (Date)earliest, (TimeZone)this.timeZone); cursor != null && cursor.compareTo((Object)end) <= 0; cursor = cursor.next()) {
                Long totalTimeLong = this.totalTimes.get(cursor);
                long totalTime = totalTimeLong == null ? 0L : totalTimeLong;
                Long totalCountLong = this.totalCounts.get(cursor);
                long totalCount = totalCountLong == null ? 0L : totalCountLong;
                long cursorStart = cursor.getFirstMillisecond();
                if (creationDate != null && creationDate.getTime() <= cursorStart && (resolutionDate == null || resolutionDate.getTime() > cursorStart)) {
                    long resolutionDateInMillis;
                    long endDate = cursor.getLastMillisecond();
                    if (this.currentTime < endDate) {
                        endDate = this.currentTime;
                    }
                    if (resolutionDate != null && (resolutionDateInMillis = resolutionDate.getTime()) < endDate) {
                        endDate = resolutionDateInMillis;
                    }
                    totalTime += endDate - creationDate.getTime();
                    ++totalCount;
                }
                this.totalTimes.put(cursor, totalTime);
                this.totalCounts.put(cursor, totalCount);
                cursor.peg(cal);
            }
        }
    }
}

