/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueConstantFactory;
import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.config.IssueTypeDeletedEvent;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.TextIssueConstant;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.status.ClearStatusCacheEvent;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.model.querydsl.QIssueType;
import com.atlassian.jira.model.querydsl.QPriority;
import com.atlassian.jira.model.querydsl.QResolution;
import com.atlassian.jira.model.querydsl.QStatus;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.lang.Pair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLQuery;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.Projections;
import com.mysema.query.types.path.NumberPath;
import com.mysema.query.types.path.StringPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class DefaultConstantsManager
implements ConstantsManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultConstantsManager.class);
    private CachedReference<ConstantsCache<Priority>> priorityCache;
    private CachedReference<ConstantsCache<Resolution>> resolutionCache;
    private CachedReference<ConstantsCache<Status>> statusCache;
    private CachedReference<IssueTypeCache> issueTypeCache;
    private final IssueConstant UNRESOLVED_RESOLUTION;
    private final JiraAuthenticationContext authenticationContext;
    private final OfBizDelegator ofBizDelegator;
    private final DbConnectionManager dbConnectionManager;
    private final EventPublisher eventPublisher;
    private final IssueConstantFactory issueConstantFactory;

    public DefaultConstantsManager(JiraAuthenticationContext authenticationContext, OfBizDelegator ofBizDelegator, DbConnectionManager dbConnectionManager, IssueConstantFactory issueConstantFactory, CacheManager cacheManager, EventPublisher eventPublisher) {
        this.dbConnectionManager = dbConnectionManager;
        this.issueConstantFactory = issueConstantFactory;
        this.authenticationContext = authenticationContext;
        this.ofBizDelegator = ofBizDelegator;
        this.eventPublisher = eventPublisher;
        this.UNRESOLVED_RESOLUTION = new TextIssueConstant("common.status.unresolved", "common.status.unresolved", null, authenticationContext);
        this.createCachedReferences(cacheManager);
    }

    private void createCachedReferences(CacheManager cacheManager) {
        this.priorityCache = cacheManager.getCachedReference(DefaultConstantsManager.class, "priorityCache", (Supplier)new PriorityCacheLoader());
        this.resolutionCache = cacheManager.getCachedReference(DefaultConstantsManager.class, "resolutionCache", (Supplier)new ResolutionCacheLoader());
        this.statusCache = cacheManager.getCachedReference(DefaultConstantsManager.class, "statusCache", (Supplier)new StatusCacheLoader());
        this.issueTypeCache = cacheManager.getCachedReference(DefaultConstantsManager.class, "issueTypeCache", (Supplier)new IssueTypeCacheLoader());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent ignored) {
        this.refresh();
    }

    @EventListener
    public void onIssueTypeDeleted(IssueTypeDeletedEvent event) {
        this.issueTypeCache.reset();
    }

    public Collection<Status> getStatuses() {
        return ((ConstantsCache)this.statusCache.get()).getObjects();
    }

    public Collection<Status> getStatusObjects() {
        return ((ConstantsCache)this.statusCache.get()).getObjects();
    }

    public Status getStatus(String id) {
        return this.getStatusObject(id);
    }

    public Status getStatusObject(String id) {
        return (Status)((ConstantsCache)this.statusCache.get()).getObject(id);
    }

    public void refreshStatuses() {
        this.statusCache.reset();
        this.eventPublisher.publish((Object)ClearStatusCacheEvent.INSTANCE);
    }

    public IssueConstant getConstantObject(String constantType, String id) {
        if (PRIORITY_CONSTANT_TYPE.equalsIgnoreCase(constantType)) {
            return this.getPriorityObject(id);
        }
        if (STATUS_CONSTANT_TYPE.equalsIgnoreCase(constantType)) {
            return this.getStatusObject(id);
        }
        if (RESOLUTION_CONSTANT_TYPE.equalsIgnoreCase(constantType)) {
            return this.getResolutionObject(id);
        }
        if (ISSUE_TYPE_CONSTANT_TYPE.equalsIgnoreCase(constantType)) {
            return this.getIssueTypeObject(id);
        }
        return null;
    }

    public Collection getConstantObjects(String constantType) {
        if (PRIORITY_CONSTANT_TYPE.equalsIgnoreCase(constantType)) {
            return this.getPriorityObjects();
        }
        if (STATUS_CONSTANT_TYPE.equalsIgnoreCase(constantType)) {
            return this.getStatusObjects();
        }
        if (RESOLUTION_CONSTANT_TYPE.equalsIgnoreCase(constantType)) {
            return this.getResolutionObjects();
        }
        if (ISSUE_TYPE_CONSTANT_TYPE.equalsIgnoreCase(constantType)) {
            return this.getAllIssueTypeObjects();
        }
        return null;
    }

    public List<IssueConstant> convertToConstantObjects(String constantType, Collection stuff) {
        if (stuff == null || stuff.isEmpty() || constantType == null) {
            return null;
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (Object o : stuff) {
            if (o instanceof GenericValue) {
                ids.add(((GenericValue)o).getString("id"));
                continue;
            }
            ids.add((String)o);
        }
        return this.getConstantsByIds(ConstantsManager.CONSTANT_TYPE.forTypeCaseInsensitive((String)constantType), ids);
    }

    @Nonnull
    public List<IssueConstant> getConstantsByIds(@Nonnull ConstantsManager.CONSTANT_TYPE constantType, @Nonnull Collection<String> ids) {
        ArrayList<IssueConstant> list = new ArrayList<IssueConstant>(ids.size());
        for (String id : ids) {
            Priority constant;
            switch (constantType) {
                case PRIORITY: {
                    constant = this.getPriorityObject(id);
                    break;
                }
                case STATUS: {
                    constant = this.getStatusObject(id);
                    break;
                }
                case RESOLUTION: {
                    if ("-1".equals(id)) {
                        constant = this.UNRESOLVED_RESOLUTION;
                        break;
                    }
                    constant = this.getResolutionObject(id);
                    break;
                }
                case ISSUE_TYPE: {
                    constant = this.getIssueTypeObject(id);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Constant type is not valid");
                }
            }
            if (constant != null) {
                list.add((IssueConstant)constant);
                continue;
            }
            log.debug(id + " returned a null constant of type " + constantType);
        }
        return list;
    }

    public boolean constantExists(String constantType, String name) {
        return this.getIssueConstantByName(constantType, name) != null;
    }

    public IssueConstant getIssueConstantByName(String constantType, String name) {
        ConstantsCache<? extends IssueConstant> constantsCache = this.getConstantsCache(constantType);
        for (IssueConstant issueConstant : constantsCache.getObjects()) {
            if (!(name == null ? issueConstant.getName() == null : name.equals(issueConstant.getName()))) continue;
            return issueConstant;
        }
        return null;
    }

    public IssueConstant getConstantByNameIgnoreCase(String constantType, String name) {
        ConstantsCache<? extends IssueConstant> constantsCache = this.getConstantsCache(constantType);
        for (IssueConstant issueConstant : constantsCache.getObjects()) {
            if (!(name == null ? issueConstant.getName() == null : name.equalsIgnoreCase(issueConstant.getName()))) continue;
            return issueConstant;
        }
        return null;
    }

    private ConstantsCache<? extends IssueConstant> getConstantsCache(String constantType) {
        if (PRIORITY_CONSTANT_TYPE.equalsIgnoreCase(constantType)) {
            return (ConstantsCache)this.priorityCache.get();
        }
        if (STATUS_CONSTANT_TYPE.equalsIgnoreCase(constantType)) {
            return (ConstantsCache)this.statusCache.get();
        }
        if (RESOLUTION_CONSTANT_TYPE.equalsIgnoreCase(constantType)) {
            return (ConstantsCache)this.resolutionCache.get();
        }
        if (ISSUE_TYPE_CONSTANT_TYPE.equalsIgnoreCase(constantType)) {
            return (ConstantsCache)this.issueTypeCache.get();
        }
        throw new IllegalArgumentException("Unknown constant type '" + constantType + "'.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IssueType insertIssueType(String name, Long sequence, String style, String description, String iconurl) throws CreateException {
        Long nextSeqId = this.ofBizDelegator.getDelegatorInterface().getNextSeqId(ConstantsManager.CONSTANT_TYPE.ISSUE_TYPE.getType());
        try {
            this.dbConnectionManager.execute(dbConnection -> {
                QIssueType it = new QIssueType("it");
                dbConnection.insert(it).set((Path)it.id, String.valueOf(nextSeqId)).set((Path)it.name, name).set((Path)it.sequence, sequence).set((Path)it.style, org.apache.commons.lang3.StringUtils.trimToNull((String)style)).set((Path)it.description, description).set((Path)it.iconurl, iconurl).execute();
            });
        }
        finally {
            this.refreshIssueTypes();
        }
        return this.getIssueType(String.valueOf(nextSeqId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IssueType insertIssueType(String name, Long sequence, String style, String description, Long avatarId) throws CreateException {
        Long nextSeqId = this.ofBizDelegator.getDelegatorInterface().getNextSeqId(ConstantsManager.CONSTANT_TYPE.ISSUE_TYPE.getType());
        try {
            this.dbConnectionManager.execute(dbConnection -> {
                QIssueType it = new QIssueType("it");
                dbConnection.insert(it).set((Path)it.id, String.valueOf(nextSeqId)).set((Path)it.name, name).set((Path)it.sequence, sequence).set((Path)it.style, style).set((Path)it.description, description).set((Path)it.avatar, avatarId).execute();
            });
        }
        finally {
            this.refreshIssueTypes();
        }
        return this.getIssueType(String.valueOf(nextSeqId));
    }

    public void validateCreateIssueType(String name, String style, String description, String iconurl, final ErrorCollection errors, final String nameFieldName) {
        this.validateName(name, (Option<IssueType>)Option.none()).foreach((Effect)new Effect<Pair<String, ErrorCollection.Reason>>(){

            public void apply(Pair<String, ErrorCollection.Reason> error) {
                errors.addError(nameFieldName, DefaultConstantsManager.this.authenticationContext.getI18nHelper().getText((String)error.first()), (ErrorCollection.Reason)error.second());
            }
        });
        if (StringUtils.isBlank((String)iconurl)) {
            errors.addError("iconurl", this.authenticationContext.getI18nHelper().getText("admin.errors.must.specify.url.for.issue.type"));
        }
    }

    public Option<Pair<String, ErrorCollection.Reason>> validateName(String name, Option<IssueType> issueTypeToUpdate) {
        if (StringUtils.isBlank((String)name)) {
            return Option.some((Object)Pair.of((Object)this.authenticationContext.getI18nHelper().getText("admin.errors.must.specify.name"), (Object)ErrorCollection.Reason.VALIDATION_FAILED));
        }
        if (StringUtils.length((String)name) > 60) {
            return Option.some((Object)Pair.of((Object)this.authenticationContext.getI18nHelper().getText("admin.errors.issuetypes.name.must.not.exceed.max.length"), (Object)ErrorCollection.Reason.VALIDATION_FAILED));
        }
        for (IssueType issueType : this.getAllIssueTypeObjects()) {
            if ((!issueTypeToUpdate.isDefined() || ((IssueType)issueTypeToUpdate.get()).equals(issueType)) && !issueTypeToUpdate.isEmpty() || !name.trim().equalsIgnoreCase(issueType.getName())) continue;
            return Option.some((Object)Pair.of((Object)this.authenticationContext.getI18nHelper().getText("admin.errors.issue.type.with.this.name.already.exists"), (Object)ErrorCollection.Reason.CONFLICT));
        }
        return Option.none();
    }

    public void validateCreateIssueTypeWithAvatar(String name, String style, String description, String avatarId, final ErrorCollection errors, final String nameFieldName) {
        this.validateName(name, (Option<IssueType>)Option.none()).foreach((Effect)new Effect<Pair<String, ErrorCollection.Reason>>(){

            public void apply(Pair<String, ErrorCollection.Reason> error) {
                errors.addError(nameFieldName, DefaultConstantsManager.this.authenticationContext.getI18nHelper().getText((String)error.first()), (ErrorCollection.Reason)error.second());
            }
        });
        if (StringUtils.isBlank((String)avatarId)) {
            errors.addError("avatarId", this.authenticationContext.getI18nHelper().getText("admin.errors.issue.type.must.specify.avatar"));
        } else {
            try {
                Long.valueOf(avatarId);
            }
            catch (NumberFormatException e) {
                errors.addError("avatarId", this.authenticationContext.getI18nHelper().getText("admin.errors.issue.type.must.specify.avatar"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIssueType(String id, String name, Long sequence, String style, String description, String iconurl) throws DataAccessException {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null.");
        }
        try {
            this.dbConnectionManager.execute(dbConnection -> {
                long rowCount = dbConnection.update((RelationalPath<?>)QIssueType.ISSUE_TYPE).set((Path)QIssueType.ISSUE_TYPE.name, (Object)name).set(QIssueType.ISSUE_TYPE.sequence, (Object)sequence).set((Path)QIssueType.ISSUE_TYPE.style, (Object)style).set((Path)QIssueType.ISSUE_TYPE.description, (Object)description).set((Path)QIssueType.ISSUE_TYPE.iconurl, (Object)iconurl).where((Predicate)QIssueType.ISSUE_TYPE.id.eq((Object)id)).execute();
                if (rowCount == 0L) {
                    throw new IllegalArgumentException("Issue Type with id '" + id + "' does not exist.");
                }
            });
        }
        finally {
            this.refreshIssueTypes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIssueType(String id, String name, Long sequence, String style, String description, Long avatarId) throws DataAccessException {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null.");
        }
        try {
            this.dbConnectionManager.execute(dbConnection -> {
                long rowCount = dbConnection.update((RelationalPath<?>)QIssueType.ISSUE_TYPE).set((Path)QIssueType.ISSUE_TYPE.name, (Object)name).set(QIssueType.ISSUE_TYPE.sequence, (Object)sequence).set((Path)QIssueType.ISSUE_TYPE.style, (Object)style).set((Path)QIssueType.ISSUE_TYPE.description, (Object)description).set(QIssueType.ISSUE_TYPE.avatar, (Object)avatarId).where((Predicate)QIssueType.ISSUE_TYPE.id.eq((Object)id)).execute();
                if (rowCount == 0L) {
                    throw new IllegalArgumentException("Issue Type with id '" + id + "' does not exist.");
                }
            });
        }
        finally {
            this.refreshIssueTypes();
        }
    }

    public void removeIssueType(String id) throws RemoveException {
        IssueType issueType = this.getIssueType(id);
        if (issueType != null) {
            try {
                this.dbConnectionManager.execute(dbConnection -> dbConnection.delete((RelationalPath<?>)QIssueType.ISSUE_TYPE).where((Predicate)QIssueType.ISSUE_TYPE.id.eq((Object)id)).execute());
            }
            finally {
                this.refreshIssueTypes();
            }
        } else {
            throw new RemoveException("Issue type with id '" + id + "' does not exist.");
        }
    }

    public void recalculateIssueTypeSequencesAndStore(List<IssueType> issueTypes) {
        try {
            this.recalculateSequenceAndStore((List<? extends IssueConstant>)issueTypes, (RelationalPath<?>)QIssueType.ISSUE_TYPE, QIssueType.ISSUE_TYPE.sequence, QIssueType.ISSUE_TYPE.id);
        }
        finally {
            this.refreshIssueTypes();
        }
    }

    public void recalculatePrioritySequencesAndStore(List<Priority> priorities) {
        try {
            this.recalculateSequenceAndStore((List<? extends IssueConstant>)priorities, (RelationalPath<?>)QPriority.PRIORITY, QPriority.PRIORITY.sequence, QPriority.PRIORITY.id);
        }
        finally {
            this.refreshPriorities();
        }
    }

    public void recalculateStatusSequencesAndStore(List<Status> statuses) {
        try {
            this.recalculateSequenceAndStore((List<? extends IssueConstant>)statuses, (RelationalPath<?>)QStatus.STATUS, QStatus.STATUS.sequence, QStatus.STATUS.id);
        }
        finally {
            this.refreshStatuses();
        }
    }

    public void recalculateResolutionSequencesAndStore(List<Resolution> resolutions) {
        try {
            this.recalculateSequenceAndStore((List<? extends IssueConstant>)resolutions, (RelationalPath<?>)QResolution.RESOLUTION, QResolution.RESOLUTION.sequence, QResolution.RESOLUTION.id);
        }
        finally {
            this.refreshResolutions();
        }
    }

    private void recalculateSequenceAndStore(List<? extends IssueConstant> constants, RelationalPath<?> entity, NumberPath<Long> sequencePath, StringPath idPath) {
        this.dbConnectionManager.execute(dbConnection -> {
            dbConnection.setAutoCommit(false);
            long sequence = 0L;
            for (IssueConstant constant : constants) {
                dbConnection.update(entity).set((Path)sequencePath, (Object)sequence).where((Predicate)idPath.eq((Object)constant.getId())).execute();
                ++sequence;
            }
            dbConnection.commit();
        });
    }

    public void storeIssueTypes(List<GenericValue> issueTypes) throws DataAccessException {
        try {
            this.ofBizDelegator.storeAll(issueTypes);
        }
        catch (DataAccessException e) {
            throw new DataAccessException("Error occurred while storing issue types to the database.", (Throwable)e);
        }
        this.refreshIssueTypes();
    }

    public void refresh() {
        this.invalidateAll();
    }

    public void invalidateAll() {
        this.priorityCache.reset();
        this.resolutionCache.reset();
        this.issueTypeCache.reset();
        this.statusCache.reset();
    }

    public void invalidate(IssueConstant constant) {
        if (constant instanceof Priority) {
            this.priorityCache.reset();
        } else if (constant instanceof Resolution) {
            this.resolutionCache.reset();
        } else if (constant instanceof IssueType) {
            this.issueTypeCache.reset();
        } else if (constant instanceof Status) {
            this.statusCache.reset();
        }
    }

    public List<String> expandIssueTypeIds(Collection<String> issueTypeIds) {
        if (issueTypeIds == null) {
            return Collections.emptyList();
        }
        for (String issueTypeId : issueTypeIds) {
            if ("-2".equals(issueTypeId)) {
                return DefaultConstantsManager.getConstantIds(this.getRegularIssueTypeObjects());
            }
            if ("-3".equals(issueTypeId)) {
                return DefaultConstantsManager.getConstantIds(this.getSubTaskIssueTypeObjects());
            }
            if (!"-4".equals(issueTypeId)) continue;
            return this.getAllIssueTypeIds();
        }
        return new ArrayList<String>(issueTypeIds);
    }

    public List<String> getAllIssueTypeIds() {
        return ((IssueTypeCache)this.issueTypeCache.get()).getCachedIds();
    }

    public IssueConstant getIssueConstant(GenericValue issueConstantGV) {
        if (issueConstantGV == null) {
            return null;
        }
        if (ISSUE_TYPE_CONSTANT_TYPE.equals(issueConstantGV.getEntityName())) {
            return this.getIssueTypeObject(issueConstantGV.getString("id"));
        }
        if (STATUS_CONSTANT_TYPE.equals(issueConstantGV.getEntityName())) {
            return this.getStatusObject(issueConstantGV.getString("id"));
        }
        if (PRIORITY_CONSTANT_TYPE.equals(issueConstantGV.getEntityName())) {
            return this.getPriorityObject(issueConstantGV.getString("id"));
        }
        if (RESOLUTION_CONSTANT_TYPE.equals(issueConstantGV.getEntityName())) {
            return this.getResolutionObject(issueConstantGV.getString("id"));
        }
        throw new IllegalArgumentException("Unknown constant entity name '" + issueConstantGV.getEntityName() + "'.");
    }

    private static List<String> getConstantIds(Collection<? extends IssueConstant> issueConstants) {
        ArrayList<String> ids = new ArrayList<String>(issueConstants.size());
        for (IssueConstant issueConstant : issueConstants) {
            ids.add(issueConstant.getId());
        }
        return ids;
    }

    public Collection<Priority> getPriorities() {
        return ((ConstantsCache)this.priorityCache.get()).getObjects();
    }

    public Collection<Priority> getPriorityObjects() {
        return ((ConstantsCache)this.priorityCache.get()).getObjects();
    }

    public Priority getPriorityObject(String id) {
        return (Priority)((ConstantsCache)this.priorityCache.get()).getObject(id);
    }

    public Priority getDefaultPriorityObject() {
        return this.getDefaultPriority();
    }

    public Priority getDefaultPriority() {
        String defaultPriorityId = ComponentAccessor.getApplicationProperties().getString("jira.constant.default.priority");
        if (defaultPriorityId == null) {
            Collection<Priority> priorities = this.getPriorityObjects();
            Priority defaultPriority = null;
            Iterator<Priority> priorityIt = priorities.iterator();
            int times = (int)Math.ceil((double)priorities.size() / 2.0);
            for (int i = 0; i < times; ++i) {
                defaultPriority = priorityIt.next();
            }
            return defaultPriority;
        }
        return this.getPriorityObject(defaultPriorityId);
    }

    public String getPriorityName(String id) {
        if ("-1".equals(id)) {
            return this.authenticationContext.getI18nHelper().getText("constants.manager.no.priority");
        }
        Priority priorityObject = this.getPriorityObject(id);
        if (priorityObject == null) {
            return this.authenticationContext.getI18nHelper().getText("constants.manager.no.priority");
        }
        return priorityObject.getName();
    }

    public Resolution getResolutionObject(String id) {
        return (Resolution)((ConstantsCache)this.resolutionCache.get()).getObject(id);
    }

    public void refreshPriorities() {
        this.priorityCache.reset();
    }

    public Collection<Resolution> getResolutions() {
        return ((ConstantsCache)this.resolutionCache.get()).getObjects();
    }

    public Collection<Resolution> getResolutionObjects() {
        return ((ConstantsCache)this.resolutionCache.get()).getObjects();
    }

    public Resolution getResolution(String id) {
        return this.getResolutionObject(id);
    }

    public void refreshResolutions() {
        this.resolutionCache.reset();
    }

    public Collection<IssueType> getAllIssueTypeObjects() {
        return ((IssueTypeCache)this.issueTypeCache.get()).getObjects();
    }

    public Collection<IssueType> getRegularIssueTypeObjects() {
        return ((IssueTypeCache)this.issueTypeCache.get()).getRegularIssueTypeObjects();
    }

    public Collection<IssueType> getSubTaskIssueTypeObjects() {
        return ((IssueTypeCache)this.issueTypeCache.get()).getSubTaskIssueTypeObjects();
    }

    public Status getStatusByName(String name) {
        Collection<Status> statusObjects = this.getStatusObjects();
        return this.findByName(name, statusObjects);
    }

    public Status getStatusByNameIgnoreCase(String name) {
        Collection<Status> statusObjects = this.getStatusObjects();
        return this.findByNameIgnoreCase(name, statusObjects);
    }

    public Status getStatusByTranslatedName(String name) {
        Collection<Status> statusObjects = this.getStatusObjects();
        Status status = this.findByTranslatedName(name, statusObjects);
        if (status == null) {
            status = this.findByName(name, statusObjects);
        }
        return status;
    }

    private Status findByName(final String name, Collection<Status> statusObjects) {
        try {
            return (Status)Iterables.find(statusObjects, (com.google.common.base.Predicate)new com.google.common.base.Predicate<Status>(){

                public boolean apply(@Nullable Status statusObject) {
                    return statusObject.getName().equals(name);
                }
            });
        }
        catch (NoSuchElementException notFound) {
            return null;
        }
    }

    private Status findByNameIgnoreCase(final String name, Collection<Status> statusObjects) {
        try {
            return (Status)Iterables.find(statusObjects, (com.google.common.base.Predicate)new com.google.common.base.Predicate<Status>(){

                public boolean apply(@Nullable Status statusObject) {
                    return statusObject.getName().equalsIgnoreCase(name);
                }
            });
        }
        catch (NoSuchElementException notFound) {
            return null;
        }
    }

    private Status findByTranslatedName(final String name, Collection<Status> statusObjects) {
        try {
            return (Status)Iterables.find(statusObjects, (com.google.common.base.Predicate)new com.google.common.base.Predicate<Status>(){

                public boolean apply(@Nullable Status statusObject) {
                    return statusObject.getNameTranslation().equals(name);
                }
            });
        }
        catch (NoSuchElementException notFound) {
            return null;
        }
    }

    public List<IssueType> getEditableSubTaskIssueTypes() {
        List ids = this.dbConnectionManager.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().from((Expression)QIssueType.ISSUE_TYPE)).where((Predicate)QIssueType.ISSUE_TYPE.style.eq((Object)"jira_subtask"))).list((Expression)Projections.bean((Path)QIssueType.ISSUE_TYPE.id, (Expression[])new Expression[0])));
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        ids.stream().map(this::getIssueType).forEach(arg_0 -> ((ImmutableList.Builder)listBuilder).add(arg_0));
        return listBuilder.build();
    }

    public IssueType getIssueType(String id) {
        return this.getIssueTypeObject(id);
    }

    public IssueType getIssueTypeObject(String id) {
        return (IssueType)((IssueTypeCache)this.issueTypeCache.get()).getObject(id);
    }

    public void refreshIssueTypes() {
        this.issueTypeCache.reset();
    }

    private class IssueTypeCacheLoader
    implements Supplier<IssueTypeCache> {
        private IssueTypeCacheLoader() {
        }

        public IssueTypeCache get() {
            List issueTypeList = DefaultConstantsManager.this.dbConnectionManager.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().from((Expression)QIssueType.ISSUE_TYPE)).orderBy(QIssueType.ISSUE_TYPE.style.asc())).orderBy(QIssueType.ISSUE_TYPE.sequence.asc())).list((Expression)QIssueType.ISSUE_TYPE));
            final ImmutableMap.Builder builder = ImmutableMap.builder();
            final ImmutableList.Builder regularIssueTypesBuilder = ImmutableList.builder();
            final ImmutableList.Builder subTaskIssueTypesBuilder = ImmutableList.builder();
            issueTypeList.stream().map(DefaultConstantsManager.this.issueConstantFactory::createIssueType).forEach(new Consumer<IssueType>(){

                @Override
                public void accept(IssueType issueType) {
                    if (issueType.isSubTask()) {
                        subTaskIssueTypesBuilder.add((Object)issueType);
                    } else {
                        regularIssueTypesBuilder.add((Object)issueType);
                    }
                    builder.put((Object)issueType.getId(), (Object)issueType);
                }
            });
            return new IssueTypeCache((ImmutableMap<String, IssueType>)builder.build(), (ImmutableList<IssueType>)regularIssueTypesBuilder.build(), (ImmutableList<IssueType>)subTaskIssueTypesBuilder.build());
        }
    }

    private class StatusCacheLoader
    implements Supplier<ConstantsCache<Status>> {
        private StatusCacheLoader() {
        }

        public ConstantsCache<Status> get() {
            List statusList = DefaultConstantsManager.this.dbConnectionManager.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().from((Expression)QStatus.STATUS)).orderBy(QStatus.STATUS.sequence.asc())).list((Expression)QStatus.STATUS));
            ImmutableMap.Builder builder = ImmutableMap.builder();
            statusList.stream().map(DefaultConstantsManager.this.issueConstantFactory::createStatus).forEach(r -> builder.put((Object)r.getId(), r));
            return new ConstantsCache<Status>(builder.build());
        }
    }

    private class ResolutionCacheLoader
    implements Supplier<ConstantsCache<Resolution>> {
        private ResolutionCacheLoader() {
        }

        public ConstantsCache<Resolution> get() {
            List resolutionList = DefaultConstantsManager.this.dbConnectionManager.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().from((Expression)QResolution.RESOLUTION)).orderBy(QResolution.RESOLUTION.sequence.asc())).list((Expression)QResolution.RESOLUTION));
            ImmutableMap.Builder builder = ImmutableMap.builder();
            resolutionList.stream().map(DefaultConstantsManager.this.issueConstantFactory::createResolution).forEach(r -> builder.put((Object)r.getId(), r));
            return new ConstantsCache<Resolution>(builder.build());
        }
    }

    private class PriorityCacheLoader
    implements Supplier<ConstantsCache<Priority>> {
        private PriorityCacheLoader() {
        }

        public ConstantsCache<Priority> get() {
            List priorityList = DefaultConstantsManager.this.dbConnectionManager.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().from((Expression)QPriority.PRIORITY)).orderBy(QPriority.PRIORITY.sequence.asc())).list((Expression)QPriority.PRIORITY));
            ImmutableMap.Builder builder = ImmutableMap.builder();
            priorityList.stream().map(DefaultConstantsManager.this.issueConstantFactory::createPriority).forEach(p -> builder.put((Object)p.getId(), p));
            return new ConstantsCache<Priority>(builder.build());
        }
    }

    private static class IssueTypeCache
    extends ConstantsCache<IssueType> {
        private final List<IssueType> regularIssueTypeObjects;
        private final List<IssueType> subTaskIssueTypeObjects;

        public IssueTypeCache(ImmutableMap<String, IssueType> idObjectMap, ImmutableList<IssueType> regularIssueTypeObjects, ImmutableList<IssueType> subTaskIssueTypeObjects) {
            super(idObjectMap);
            this.regularIssueTypeObjects = regularIssueTypeObjects;
            this.subTaskIssueTypeObjects = subTaskIssueTypeObjects;
        }

        public List<IssueType> getRegularIssueTypeObjects() {
            return this.regularIssueTypeObjects;
        }

        public List<IssueType> getSubTaskIssueTypeObjects() {
            return this.subTaskIssueTypeObjects;
        }
    }

    static class ConstantsCache<T extends IssueConstant> {
        private final Map<String, T> idObjectMap;
        private final List<String> idList;

        public ConstantsCache(ImmutableMap<String, T> issueConstantMap) {
            this.idObjectMap = issueConstantMap;
            List ids = DefaultConstantsManager.getConstantIds((Collection)issueConstantMap.values());
            this.idList = Collections.unmodifiableList(ids);
        }

        Collection<T> getObjects() {
            return this.idObjectMap.values();
        }

        T getObject(String id) {
            return (T)((IssueConstant)this.idObjectMap.get(id));
        }

        List<String> getCachedIds() {
            return this.idList;
        }
    }
}

