/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.database;

import com.atlassian.jira.config.database.jdbcurlparser.JdbcUrlParser;
import com.atlassian.jira.config.database.jdbcurlparser.MySqlUrlParser;
import com.atlassian.jira.config.database.jdbcurlparser.OracleUrlParser;
import com.atlassian.jira.config.database.jdbcurlparser.PostgresUrlParser;
import com.atlassian.jira.config.database.jdbcurlparser.SqlServerUrlParser;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.stream.Collectors;

public enum DatabaseType {
    H2("H2", "h2", "unknown", null, (ImmutableList<String>)ImmutableList.of((Object)"org.h2.Driver")),
    HSQL("HSQL", "hsql", "unknown", null, (ImmutableList<String>)ImmutableList.of((Object)"org.hsqldb.jdbcDriver")),
    SQL_SERVER("SQL Server", "mssql", "Database", new SqlServerUrlParser(), (ImmutableList<String>)ImmutableList.of((Object)"net.sourceforge.jtds.jdbc.Driver", (Object)"com.microsoft.jdbc.sqlserver.SQLServerDriver")),
    MY_SQL("MySQL", "mysql", "Database", new MySqlUrlParser(), (ImmutableList<String>)ImmutableList.of((Object)"com.mysql.jdbc.Driver")),
    ORACLE("Oracle", "oracle10g", "SID", new OracleUrlParser(), (ImmutableList<String>)ImmutableList.of((Object)"oracle.jdbc.OracleDriver")),
    POSTGRES("PostgreSQL", "postgres72", "Database", new PostgresUrlParser(), (ImmutableList<String>)ImmutableList.of((Object)"org.postgresql.Driver")),
    UKNOWN("Uknown", "unknown", "unknown", null, (ImmutableList<String>)ImmutableList.of());

    private final String name;
    private final String typeName;
    private final JdbcUrlParser jdbcUrlParser;
    private final ImmutableList<String> drivers;
    private final String instanceFieldName;

    private DatabaseType(String name, String typeName, String instanceFieldName, JdbcUrlParser jdbcUrlParser, ImmutableList<String> drivers) {
        this.name = name;
        this.typeName = typeName;
        this.instanceFieldName = instanceFieldName;
        this.jdbcUrlParser = jdbcUrlParser;
        this.drivers = drivers;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getJdbcDriverClassName() {
        if (this.drivers.isEmpty()) {
            throw new RuntimeException("No Driver class name defined for " + this.name());
        }
        return (String)this.drivers.get(0);
    }

    public static Collection<DatabaseType> knownTypes() {
        return DatabaseType.allTypes().stream().filter(type -> type != UKNOWN).collect(Collectors.toList());
    }

    public static Collection<DatabaseType> allTypes() {
        return ImmutableList.copyOf((Object[])DatabaseType.values());
    }

    public static DatabaseType forJdbcDriverClassName(String jdbcDriverClass) {
        if (jdbcDriverClass == null) {
            return H2;
        }
        return DatabaseType.knownTypes().stream().filter(databaseType -> databaseType.drivers.contains((Object)jdbcDriverClass)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown database type name " + jdbcDriverClass));
    }

    public static DatabaseType forDatabaseTypeName(String typeName) {
        return DatabaseType.knownTypes().stream().filter(databaseType -> databaseType.getTypeName().contains(typeName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown database type name " + typeName));
    }

    public JdbcUrlParser getJdbcUrlParser() {
        if (this.jdbcUrlParser == null) {
            throw new UnsupportedOperationException("Parser implementation not available for " + this.name());
        }
        return this.jdbcUrlParser;
    }

    public String getInstanceFieldName() {
        return this.instanceFieldName;
    }
}

