/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.feature;

import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Set;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;

public class FeatureFlagDataProvider
implements WebResourceDataProvider {
    private final FeatureManager featureManager;
    private final ObjectMapper configuredObjectMapper;

    public FeatureFlagDataProvider(FeatureManager featureManager) {
        this.featureManager = featureManager;
        this.configuredObjectMapper = new ObjectMapper();
        this.configuredObjectMapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
    }

    public Jsonable get() {
        Set registeredFlags = this.featureManager.getRegisteredFlags();
        HashMap featureFlagData = Maps.newHashMap();
        for (FeatureFlag featureFlag : registeredFlags) {
            featureFlagData.put(featureFlag.featureKey(), featureFlag.isOnByDefault());
        }
        Set allJiraEnabledFeatures = this.featureManager.getDarkFeatures().getAllEnabledFeatures();
        final HashMap topLevelMap = Maps.newHashMap();
        topLevelMap.put("enabled-feature-keys", allJiraEnabledFeatures);
        topLevelMap.put("feature-flag-states", featureFlagData);
        return new Jsonable(){

            public void write(Writer writer) throws IOException {
                FeatureFlagDataProvider.this.configuredObjectMapper.writeValue(writer, (Object)topLevelMap);
            }
        };
    }
}

